import { TolgeeOn, UpdateEvent } from '../../types';
export declare function Events(): Readonly<{
    onPendingLanguageChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"pendingLanguage", string>>) => import("../../types").Subscription;
        readonly emit: (data: string) => void;
    };
    onLanguageChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"language", string>>) => import("../../types").Subscription;
        readonly emit: (data: string) => void;
    };
    onLoadingChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"loading", boolean>>) => import("../../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onFetchingChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"fetching", boolean>>) => import("../../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onInitialLoaded: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"initialLoad", void>>) => import("../../types").Subscription;
        readonly emit: (data: void) => void;
    };
    onRunningChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"running", boolean>>) => import("../../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onCacheChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"cache", import("../../types").CacheDescriptorWithKey>>) => import("../../types").Subscription;
        readonly emit: (data: import("../../types").CacheDescriptorWithKey) => void;
    };
    onPermanentChange: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"permanentChange", import("../../types").TranslationDescriptor>>) => import("../../types").Subscription;
        readonly emit: (data: import("../../types").TranslationDescriptor) => void;
    };
    onError: {
        readonly listen: (handler: import("../../types").Handler<import("../../types").ListenerEvent<"error", import("../../types").TolgeeError>>) => import("../../types").Subscription;
        readonly emit: (data: import("../../types").TolgeeError) => void;
    };
    onUpdate: import("./EventEmitterCombined").EventEmitterCombinedInstance<UpdateEvent>;
    setEmitterActive(active: boolean): void;
    on: TolgeeOn<keyof import("../../types").EventType>;
}>;
export type EventsInstance = ReturnType<typeof Events>;
