import ansi from 'ansi-colors';
export function renderKey(key, note) {
    const colorFunc = ansi.yellow;
    const namespace = key.namespace
        ? ` ${ansi.italic(`(namespace: ${key.namespace})`)}`
        : '';
    const renderedNote = note ? ` ${note}` : '';
    return `${colorFunc(`${key.keyName}`)}${namespace}${renderedNote}`;
}
export function getUnresolvedConflictsMessage(translations, isError) {
    const someOverridable = Boolean(translations.find((c) => c.isOverridable));
    const result = [''];
    result.push(`🟡 Some translations cannot be updated:`);
    translations.forEach((c) => {
        result.push(renderKey({ keyName: c.keyName, namespace: c.keyNamespace }, `${c.language}` + (c.isOverridable ? ' (overridable)' : '')));
    });
    result.push('');
    if (someOverridable) {
        result.push('HINT: Overridable translations can be updated with the `--override-mode ALL`');
        result.push('');
    }
    return result.join('\n');
}
export function printUnresolvedConflicts(translations, isError) {
    console.log(getUnresolvedConflictsMessage(translations, isError));
}
