import ansi from 'ansi-colors';
export function tokensToString(tokens, originalString, getColorizer) {
    const result = [];
    let lastIndex = 0;
    let lastColorizer;
    for (const token of tokens) {
        const colorizer = getColorizer(token);
        if (lastIndex < token.startIndex) {
            if (colorizer === lastColorizer) {
                result.push(colorizer(originalString.substring(lastIndex, token.startIndex)));
            }
            else {
                result.push(ansi.grey(originalString.substring(lastIndex, token.startIndex)));
            }
        }
        lastIndex = token.endIndex;
        const fullText = originalString.substring(token.startIndex, token.endIndex);
        result.push(getColorizer(token)(fullText));
    }
    if (lastIndex < originalString.length) {
        result.push(originalString.substring(lastIndex, originalString.length));
    }
    return result
        .join('')
        .split('\n')
        .map((line, index) => `${ansi.gray(String(index + 1).padEnd(3))}${line}`)
        .join('\n');
}
