import { parseGeneral } from './parseGeneral.js';
/*
 * React.createElement(T, { keyName: 'key1' }, "default value")
 *                     ^--------------------------------------^
 *
 * or
 *
 * ['item', 'item']
 * ^--------------^
 */
export function parseList(context, end) {
    const { tokens, getCurrentLine } = context;
    const line = getCurrentLine();
    tokens.next();
    const result = [];
    let token;
    while ((token = tokens.current())) {
        if (end && end === token.customType) {
            tokens.next();
            break;
        }
        switch (token.customType) {
            case 'separator.comma':
                tokens.next();
                break;
            default:
                result.push(parseGeneral(context, {
                    end: ['separator.comma', end],
                }));
        }
    }
    return { type: 'array', line, values: result };
}
