import { simplifyNode } from '../nodeUtils.js';
import { getValue } from './getValue.js';
import { parseList } from './parseList.js';
import { parseObject } from './parseObject.js';
export function parseGeneral(context, options) {
    const { tokens, ruleMap, withLabel, blocks } = context;
    const { end, keepNested } = options;
    const result = {
        type: 'expr',
        line: context.getCurrentLine(),
        values: [],
    };
    let token;
    while ((token = tokens.current())) {
        const type = token.customType;
        if (!token || (end && end.includes(token.customType))) {
            break;
        }
        if (!type) {
            result.values.push(getValue(context));
            tokens.next();
        }
        else if (ruleMap.has(type)) {
            result.values.push(withLabel(ruleMap.get(type))(context));
            if (token === tokens.current()) {
                throw new Error(`SYSTEM ERROR: Rule "${type}" didn't consume any tokens`);
            }
            // not loading new token when rule ended
        }
        else if (type === 'block.begin') {
            result.values.push(withLabel(parseObject)(context));
        }
        else if (type === 'list.begin') {
            result.values.push(withLabel(parseList)(context, 'list.end'));
            // list consumes last token, so no loading next
        }
        else if (blocks[type]) {
            withLabel(tokens.next)();
            result.values.push(withLabel(parseGeneral)(context, {
                end: blocks[type],
                keepNested,
            }));
            withLabel(tokens.next)();
        }
        else {
            result.values.push(getValue(context));
            tokens.next();
        }
    }
    return keepNested ? result : simplifyNode(result);
}
