import { parseGeneral } from './parseGeneral.js';
export function getValue(context) {
    const token = context.tokens.current();
    const line = context.getCurrentLine();
    switch (token === null || token === void 0 ? void 0 : token.customType) {
        case 'string':
        case 'primitive.null':
            return { type: 'primitive', line, value: token.token };
        case 'expression.begin':
            context.tokens.next();
            return parseGeneral(context, {
                end: ['expression.end'],
            });
        default:
            return { type: 'expr', line, values: [] };
    }
}
