var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
export function getCombinedOptions(_a, line) {
    var { ns, noWrap, orEmpty, params, language } = _a, rest = __rest(_a, ["ns", "noWrap", "orEmpty", "params", "language"]);
    const options = {
        ns: ns,
        noWrap: noWrap,
        orEmpty: orEmpty,
        language: language,
    };
    return Object.assign(Object.assign({}, options), { params: {
            type: 'dict',
            line,
            value: Object.assign({}, rest),
            unknown: [],
        } });
}
export const getTranslateProps = (node) => {
    var _a;
    const [keyOrProps, ...params] = node.values;
    let result = {
        type: 'dict',
        line: node.line,
        value: {},
        unknown: [],
    };
    let options = undefined;
    if ((keyOrProps === null || keyOrProps === void 0 ? void 0 : keyOrProps.type) === 'dict') {
        result = keyOrProps;
    }
    else {
        result.value.key = keyOrProps;
        if (((_a = params[0]) === null || _a === void 0 ? void 0 : _a.type) === 'primitive' || params.length >= 2) {
            result.value.defaultValue = params[0];
            options = params[1];
        }
        else {
            options = params[0];
        }
    }
    let optionsDynamic = false;
    if ((options === null || options === void 0 ? void 0 : options.type) === 'dict') {
        result.value = Object.assign(Object.assign({}, getCombinedOptions(options.value, options.line)), result.value);
        result.unknown.push(...options.unknown);
    }
    else if (options) {
        optionsDynamic = true;
    }
    return { result, optionsDynamic };
};
