export function isPrimitive(node) {
    return node.type === 'primitive';
}
export function isString(node) {
    return node.type === 'primitive' && typeof node.value === 'string';
}
export function isEmptyExpr(node) {
    return node.type === 'expr' && node.values.length === 0;
}
export function extractString(node) {
    return node && isString(node) ? node.value : undefined;
}
export function extractValue(node) {
    return node && node.type === 'primitive' ? node.value : undefined;
}
export function simplifyNode(node) {
    if ((node === null || node === void 0 ? void 0 : node.type) === 'expr' && node.values.length === 1) {
        return node.values[0];
    }
    return node;
}
