export const createIterator = (items) => {
    const iterator = items[Symbol.iterator]();
    let currentItem;
    let nextItem = iterator.next();
    const listeners = [];
    let currentContext = undefined;
    const self = {
        getLineNumber() {
            var _a;
            return (_a = currentItem === null || currentItem === void 0 ? void 0 : currentItem.line) !== null && _a !== void 0 ? _a : 0;
        },
        current() {
            return currentItem;
        },
        peek() {
            return nextItem.done ? undefined : nextItem.value;
        },
        onAccept(listener) {
            listeners.push(listener);
        },
        setLabel(context) {
            currentContext = context;
        },
        getLabel() {
            return currentContext;
        },
        next() {
            const value = self.peek();
            if (currentItem) {
                listeners.forEach((cb) => cb(currentItem, currentContext));
            }
            currentItem = nextItem.done ? undefined : nextItem.value;
            nextItem = iterator.next();
            return value;
        },
    };
    return self;
};
