var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Command, Option } from 'commander';
import { unzipBuffer } from '../utils/zip.js';
import { prepareDir } from '../utils/prepareDir.js';
import { exitWithError, loading, success } from '../utils/logger.js';
import { checkPathNotAFile } from '../utils/checkPathNotAFile.js';
import { mapExportFormat } from '../utils/mapExportFormat.js';
import { handleLoadableError } from '../client/TolgeeClient.js';
function fetchZipBlob(opts) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const exportFormat = mapExportFormat(opts.format);
        const { format, messageFormat } = exportFormat;
        const loadable = yield opts.client.export.export({
            format,
            messageFormat,
            supportArrays: opts.supportArrays,
            languages: opts.languages,
            filterState: opts.states,
            structureDelimiter: (_a = opts.delimiter) !== null && _a !== void 0 ? _a : '',
            filterNamespace: opts.namespaces,
            filterTagIn: opts.tags,
            filterTagNotIn: opts.excludeTags,
            fileStructureTemplate: opts.fileStructureTemplate,
            escapeHtml: false,
        });
        handleLoadableError(loadable);
        return loadable.data;
    });
}
const pullHandler = () => function () {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        if (!opts.path) {
            exitWithError('Missing option --path <path> or `pull.path` in tolgee config');
        }
        yield checkPathNotAFile(opts.path);
        const zipBlob = yield loading('Fetching strings from Tolgee...', fetchZipBlob(opts));
        yield prepareDir(opts.path, opts.emptyDir);
        yield loading('Extracting strings...', unzipBuffer(zipBlob, opts.path));
        success('Done!');
    });
};
export default (config) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    return new Command()
        .name('pull')
        .description('Pulls translations from Tolgee')
        .addOption(new Option('--path <path>', 'Destination of a folder where translation files will be stored in').default((_a = config.pull) === null || _a === void 0 ? void 0 : _a.path))
        .addOption(new Option('-l, --languages <languages...>', 'List of languages to pull. Leave unspecified to export them all').default((_b = config.pull) === null || _b === void 0 ? void 0 : _b.languages))
        .addOption(new Option('-s, --states <states...>', 'List of translation states to include. Defaults all except untranslated')
        .choices(['UNTRANSLATED', 'TRANSLATED', 'REVIEWED'])
        .default((_c = config.pull) === null || _c === void 0 ? void 0 : _c.states)
        .argParser((v, a) => [v.toUpperCase(), ...(a || [])]))
        .addOption(new Option('-d, --delimiter <delimiter>', 'Structure delimiter to use. By default, Tolgee interprets `.` as a nested structure. You can change the delimiter, or disable structure formatting by not specifying any value to the option').default(((_d = config.pull) === null || _d === void 0 ? void 0 : _d.delimiter) === undefined ? '.' : config.pull.delimiter))
        .addOption(new Option('-n, --namespaces <namespaces...>', 'List of namespaces to pull. Defaults to all namespaces').default((_e = config.pull) === null || _e === void 0 ? void 0 : _e.namespaces))
        .addOption(new Option('-t, --tags <tags...>', 'List of tags which to include. Keys tagged by at least one of these tags will be included.').default((_f = config.pull) === null || _f === void 0 ? void 0 : _f.tags))
        .addOption(new Option('--exclude-tags <tags...>', 'List of tags which to exclude. Keys tagged by at least one of these tags will be excluded.').default((_g = config.pull) === null || _g === void 0 ? void 0 : _g.excludeTags))
        .addOption(new Option('--support-arrays', 'Export keys with array syntax (e.g. item[0]) as arrays.').default((_j = (_h = config.pull) === null || _h === void 0 ? void 0 : _h.supportArrays) !== null && _j !== void 0 ? _j : false))
        .addOption(new Option('--empty-dir', 'Empty target directory before inserting pulled files.').default((_k = config.pull) === null || _k === void 0 ? void 0 : _k.emptyDir))
        .addOption(new Option('--file-structure-template <template>', 'Defines exported file structure: https://tolgee.io/tolgee-cli/push-pull-strings#file-structure-template-format').default((_l = config.pull) === null || _l === void 0 ? void 0 : _l.fileStructureTemplate))
        .action(pullHandler());
};
