var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { relative } from 'path';
import { Command } from 'commander';
import { extractKeysOfFiles } from '../../extractor/runner.js';
import { WarningMessages, emitGitHubWarning, } from '../../extractor/warnings.js';
import { loading } from '../../utils/logger.js';
const lintHandler = (config) => function () {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        const extracted = yield loading('Analyzing code...', extractKeysOfFiles(opts));
        let warningCount = 0;
        let filesCount = 0;
        for (const [file, { warnings }] of extracted) {
            if (warnings === null || warnings === void 0 ? void 0 : warnings.length) {
                warningCount += warnings.length;
                filesCount++;
                const relFile = relative(process.cwd(), file);
                console.log('%s:', relFile);
                for (const warning of warnings) {
                    if (warning.warning in WarningMessages) {
                        const warn = warning.warning;
                        const { name } = WarningMessages[warn];
                        console.log('\tline %d: %s', warning.line, name);
                    }
                    else {
                        console.log('\tline %d: %s', warning.line, warning.warning);
                    }
                    emitGitHubWarning(warning.warning, file, warning.line);
                }
            }
        }
        if (warningCount !== 0) {
            console.log();
            console.log('Total: %d warning%s in %d file%s', warningCount, warningCount !== 1 ? 's' : '', filesCount, filesCount !== 1 ? 's' : '');
            process.exit(1);
        }
        console.log('No issues found.');
    });
};
export default (config) => new Command('check')
    .description('Checks if the keys can be extracted automatically, and reports problems if any')
    .action(lintHandler(config));
