var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { pathToPosix } from '../utils/pathToPosix.js';
export const createImportClient = ({ apiClient }) => {
    return {
        import(data) {
            return __awaiter(this, void 0, void 0, function* () {
                const body = new FormData();
                for (const file of data.files) {
                    // converting paths to posix style, so it's correctly matched on the server
                    body.append('files', new Blob([file.data]), pathToPosix(file.name));
                }
                data.params.fileMappings = data.params.fileMappings.map((i) => (Object.assign(Object.assign({}, i), { 
                    // converting paths to posix style, so it's correctly matched on the server
                    fileName: pathToPosix(i.fileName) })));
                body.append('params', JSON.stringify(data.params));
                return apiClient.POST('/v2/projects/{projectId}/single-step-import', {
                    params: { path: { projectId: apiClient.getProjectId() } },
                    body: body,
                    bodySerializer: (r) => r,
                });
            });
        },
    };
};
