import { Err, Ok, Result } from 'ts-results-es';
import { MyError, Try } from '../utils/error';
import { NarviCharacter } from './bindings/NarviCharacter';

export class Narvi {
    backend_url: URL;
    fetch_function: (path: string, args: RequestInit | undefined) => Promise<Response> = (
        path,
        args
    ) => {
        const url = new URL(path, this.backend_url);
        return fetch(url, args);
    };
    constructor(backend_url: URL) {
        this.backend_url = backend_url;
    }
    async call_backend<Type>(
        method: string,
        path: string,
        body: BodyInit | null = null,
        no_answer: boolean = false
    ): Promise<Result<Type, MyError>> {
        try {
            const response = await this.fetch_function(path, {
                method: method,
                body: body
            });
            if (!response.ok) {
                const text = await response.text();
                return Err(new MyError(text));
            }
            if (no_answer) {
                return Ok(null as Type);
            }
            return Ok(await response.json());
        } catch (error) {
            console.log(error);
            return Err(new MyError(String(error)));
        }
    }

    async get_character(key: string): Promise<Try<NarviCharacter>> {
        return await this.call_backend('POST', '/', JSON.stringify({ key: key }));
    }
}
