use sea_orm::DeriveIden;
use serde::{Deserialize, Serialize};
use std::cmp::max;
use strum::{EnumCount, EnumIter};
use ts_rs::TS;

use crate::character_data::CharacterData;

#[derive(
    PartialEq,
    Copy,
    Clone,
    Serialize,
    Deserialize,
    Debug,
    EnumIter,
    EnumCount,
    TS,
    DeriveIden,
    Hash,
    Eq,
)]
#[ts(export)]
pub enum VirtueEnum {
    AHuntersResolve,
    AgainstTheUnseen,
    AllegianceOfTheDunedain,
    AncientFire,
    ArtOfDisappearing,
    ArtificerOfEregion,
    BarukKhazad,
    BeautyOfTheStars,
    BeornsEnchantment,
    BesetByWoe,
    BraveAtAPinch,
    BreeBlood,
    BreePony,
    BrokenSpells,
    BrotherToBears,
    Confidence,
    Cram,
    DarkForDarkBusiness,
    DeadlyArchery,
    Defiance,
    DesperateCourage,
    DourHanded,
    DragonSlayer,
    DurinsWay,
    DwarfFriend,
    ElberethGilthoniel,
    ElfLights,
    ElvenSkill,
    ElvenWise,
    ElvishDreams,
    EnduranceOfTheRanger,
    FavourOfTheLady,
    FierceShot,
    FolkOfTheDusk,
    ForesightOfTheirKindred,
    ForestHarrier,
    FriendlyAndFamiliar,
    Furious,
    GleamOfWrath,
    GreatStrength,
    Halflings,
    Hardiness,
    HeirOfArnor,
    HerbalRemedies,
    HighDestiny,
    HobbitSense,
    HoundOfMirkwood,
    KingsOfMen,
    Lembas,
    Mastery,
    MemoryOfAncientDays,
    MightOfTheFirstborn,
    NaturalWatchfulness,
    Naugrim,
    Nimbless,
    PettyDwarves,
    Prowess,
    Redoubtable,
    RoyaltyRevealed,
    ShotsInTheDark,
    SkillOfTheEldar,
    SkinCoat,
    SmallFolk,
    SplittingBlow,
    StaunchingSong,
    StoneHard,
    StoutHearted,
    StrangeAsNewsFromBree,
    StrengthOfWill,
    SureAtTheMark,
    TelcharsSecrets,
    TheArtOfSmoking,
    TheLanguageOfBirds,
    TheLongDefeat,
    ThreeIsCompany,
    ToughAsOldTreeRoots,
    TreePeople,
    TwiceBakedHoneyCakes,
    UntameableSpirit,
    WaysOfTheWild,
    WoodGoer,
}

impl VirtueEnum {
    pub fn increase_endurance(&self, data: &CharacterData) -> u32 {
        if matches!(
            self,
            VirtueEnum::AncientFire
                | VirtueEnum::BrotherToBears
                | VirtueEnum::Defiance
                | VirtueEnum::EnduranceOfTheRanger
                | VirtueEnum::StoneHard
        ) {
            return 1;
        } else if *self == VirtueEnum::Hardiness {
            max(2, data.wisdom)
        } else {
            return 0;
        }
    }

    pub fn increase_hope(&self, _: &CharacterData) -> u32 {
        if matches!(
            self,
            VirtueEnum::BeautyOfTheStars
                | VirtueEnum::BreePony
                | VirtueEnum::ElberethGilthoniel
                | VirtueEnum::FavourOfTheLady
                | VirtueEnum::StaunchingSong
                | VirtueEnum::UntameableSpirit
        ) {
            return 1;
        } else if matches!(self, VirtueEnum::Confidence) {
            return 2;
        } else {
            return 0;
        }
    }

    pub fn increase_parry(&self, _: &CharacterData) -> u32 {
        if matches!(self, VirtueEnum::Nimbless) {
            return 1;
        } else {
            return 0;
        }
    }
}
