use axum::{
    http::{Response as HttpResponse, StatusCode},
    response::{IntoResponse, Response},
};
use serde::Serialize;
use tracing::error;

pub struct CacheResponse<T> {
    data: T,
}

impl<T> CacheResponse<T> {
    pub fn new(data: T) -> Self {
        Self { data }
    }
}

impl<T> IntoResponse for CacheResponse<T>
where
    T: Serialize,
{
    fn into_response(self) -> Response {
        let data = serde_json::to_string(&self.data);
        if let Ok(data) = data {
            HttpResponse::builder()
                .header("Content-Type", "application/json")
                // 1 day of cache
                .header("Cache-Control", "max-age=240")
                .body(data)
                .expect("Failed to build cached response")
                .into_response()
        } else {
            error!("Failure in cache {data:?}");
            StatusCode::INTERNAL_SERVER_ERROR.into_response()
        }
    }
}
