//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.14

use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "fellowship")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    pub name: String,
    pub eye: i32,
    pub points: i32,
    pub patron_id: Option<i32>,
    pub owner_id: i32,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(has_many = "super::fellowship_adversary::Entity")]
    FellowshipAdversary,
    #[sea_orm(has_many = "super::fellowship_character::Entity")]
    FellowshipCharacter,
    #[sea_orm(has_many = "super::message::Entity")]
    Message,
    #[sea_orm(
        belongs_to = "super::patron::Entity",
        from = "Column::PatronId",
        to = "super::patron::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Patron,
    #[sea_orm(
        belongs_to = "super::user::Entity",
        from = "Column::OwnerId",
        to = "super::user::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    User,
}

impl Related<super::fellowship_adversary::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FellowshipAdversary.def()
    }
}

impl Related<super::fellowship_character::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FellowshipCharacter.def()
    }
}

impl Related<super::message::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Message.def()
    }
}

impl Related<super::patron::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Patron.def()
    }
}

impl Related<super::user::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::User.def()
    }
}

impl Related<super::adversary::Entity> for Entity {
    fn to() -> RelationDef {
        super::fellowship_adversary::Relation::Adversary.def()
    }
    fn via() -> Option<RelationDef> {
        Some(
            super::fellowship_adversary::Relation::Fellowship
                .def()
                .rev(),
        )
    }
}

impl Related<super::character::Entity> for Entity {
    fn to() -> RelationDef {
        super::fellowship_character::Relation::Character.def()
    }
    fn via() -> Option<RelationDef> {
        Some(
            super::fellowship_character::Relation::Fellowship
                .def()
                .rev(),
        )
    }
}

impl ActiveModelBehavior for ActiveModel {}
