//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.14

use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "adversary")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    pub name: String,
    pub features: String,
    pub attribute_level: i32,
    pub current_endurance: i32,
    pub max_endurance: i32,
    pub might: i32,
    pub current_hate: i32,
    pub max_hate: i32,
    #[sea_orm(column_type = "custom(\"enum_text\")")]
    pub hate_type: String,
    pub parry: i32,
    pub armour: i32,
    pub owner_id: i32,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(has_many = "super::adversary_combat_proficiency::Entity")]
    AdversaryCombatProficiency,
    #[sea_orm(has_many = "super::fell_ability::Entity")]
    FellAbility,
    #[sea_orm(has_many = "super::fellowship_adversary::Entity")]
    FellowshipAdversary,
    #[sea_orm(
        belongs_to = "super::user::Entity",
        from = "Column::OwnerId",
        to = "super::user::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    User,
}

impl Related<super::adversary_combat_proficiency::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::AdversaryCombatProficiency.def()
    }
}

impl Related<super::fell_ability::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FellAbility.def()
    }
}

impl Related<super::fellowship_adversary::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FellowshipAdversary.def()
    }
}

impl Related<super::user::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::User.def()
    }
}

impl Related<super::fellowship::Entity> for Entity {
    fn to() -> RelationDef {
        super::fellowship_adversary::Relation::Fellowship.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::fellowship_adversary::Relation::Adversary.def().rev())
    }
}

impl ActiveModelBehavior for ActiveModel {}
