import { toast } from '@zerodevx/svelte-toast';
import type { NarviCharacter } from 'the-one-app-api/narvi/bindings/NarviCharacter';

export async function fetch_narvi(url: string, key: string): Promise<NarviCharacter> {
    const resp = await fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ key: key })
    });
    if (!resp.ok) {
        const text = 'Failed to fetch character from narvi';
        toast.push(text);
        throw text;
    }
    return (await resp.json()) as NarviCharacter;
}
