import { derived } from 'svelte/store';
import { getTranslateProps } from '@tolgee/web';
import getTranslateInternal from './getTranslateInternal';
const getTranslate = (ns) => {
    const { t: tInternal, isLoading } = getTranslateInternal(ns);
    const t = derived(tInternal, (value) => (...params) => {
        // @ts-expect-error passing params as they were
        const props = getTranslateProps(...params);
        return value(props);
    });
    return { t, isLoading: isLoading };
};
export default getTranslate;
