import { CacheDescriptor, NsFallback, TolgeeOptions, TFnType, NsType, KeyAndNamespacesInternal, CacheDescriptorInternal, LoadOptions, LoadRequiredOptions, LoadMatrixOptions } from '../types';
type StateServiceProps = {
    options?: Partial<TolgeeOptions>;
};
export declare function Controller({ options }: StateServiceProps): Readonly<{
    init: (options: Partial<TolgeeOptions>) => void;
    getTranslation: ({ key, ns, language }: KeyAndNamespacesInternal) => string | undefined;
    changeTranslation: (descriptor: CacheDescriptor, key: string, value: string) => {
        revert(): void;
    };
    getTranslationNs: ({ key, ns }: KeyAndNamespacesInternal) => string[];
    getDefaultAndFallbackNs: (ns?: NsType) => string[];
    findPositions: import("../types").FindPositionsInterface;
    getRequiredDescriptors: (lang?: string, ns?: NsFallback) => CacheDescriptorInternal[];
    changeLanguage(language: string): Promise<void>;
    addActiveNs(ns: NsFallback, forget?: boolean): Promise<void>;
    loadRecord(descriptor: CacheDescriptor, options?: LoadOptions): Promise<import("../types").TranslationsFlat>;
    isLoading(ns?: NsFallback): boolean;
    isLoaded(ns?: NsFallback): boolean;
    t: TFnType<import("../types").DefaultParamType, string, import("../types").TranslationKey>;
    isDev(): boolean;
    loadRequired(options?: LoadRequiredOptions): Promise<import("../types").CacheInternalRecord[]>;
    loadMatrix(options: LoadMatrixOptions): Promise<import("../types").CacheInternalRecord[]>;
    run(): Promise<any>;
    stop(): void;
    addStaticData: (data: import("./State/initState").TolgeeStaticDataProp | undefined) => void;
    invalidate: () => void;
    addRecord: (descriptor: CacheDescriptorInternal, data: import("../types").TreeTranslationsData) => void;
    exists: (descriptor: CacheDescriptorInternal, strict?: boolean) => boolean;
    getRecord: (descriptor: CacheDescriptor) => import("../types").CacheInternalRecord | undefined;
    getAllRecords: () => (import("../types").CacheInternalRecord | undefined)[];
    getTranslationFallback: (namespaces: string[], languages: string[], key: string) => string | undefined;
    isFetching: (ns?: NsFallback) => boolean;
    loadRecords: (descriptors: CacheDescriptor[], options?: LoadOptions | undefined) => Promise<import("../types").CacheInternalRecord[]>;
    addPlugin: (tolgeeInstance: import("../TolgeeCore").TolgeeInstance, plugin: import("../types").TolgeePlugin) => void;
    getLanguageStorage: () => import("../types").LanguageStorageMiddleware | undefined;
    getInitialLanguage: () => string | Promise<string | undefined> | Promise<string | Promise<string | undefined> | undefined> | undefined;
    setStoredLanguage: (language: string) => void | Promise<void | undefined> | undefined;
    getDevBackend: () => import("../types").BackendDevMiddleware | undefined;
    getBackendRecord: import("../types").BackendGetRecordInternal;
    getBackendDevRecord: import("../types").BackendGetRecordInternal;
    getLanguageDetector: () => import("../types").LanguageDetectorMiddleware | undefined;
    retranslate: () => void;
    highlight: import("../types").HighlightInterface;
    unwrap: (text: string) => import("../types").Unwrapped;
    wrap: (params: import("../types").WrapperWrapProps) => string | undefined;
    hasDevBackend: () => boolean;
    formatTranslation: ({ formatEnabled, ...props }: {
        key: import("../types").TranslationKey;
        defaultValue?: string | undefined;
        params?: import("../types").TranslateParams<import("../types").DefaultParamType> | undefined;
    } & import("../types").TranslateOptions & {
        translation?: string | undefined;
    } & {
        formatEnabled?: boolean | undefined;
    }) => string;
    isRunning: () => boolean;
    setRunning: (value: boolean) => void;
    isInitialLoading: () => boolean;
    setInitialLoading: (value: boolean) => void;
    getLanguage: () => string | undefined;
    setLanguage: (language: string) => void;
    getPendingLanguage: () => string | undefined;
    setPendingLanguage: (language: string) => void;
    getInitialOptions: () => {
        apiUrl?: string | undefined;
        apiKey?: string | undefined;
        projectId?: string | number | undefined;
        language?: string | undefined;
        defaultLanguage?: string | undefined;
        availableLanguages?: string[] | undefined;
        fallbackLanguage?: import("../types").FallbackLanguageOption;
        ns?: string[] | undefined;
        fallbackNs?: import("../types").FallbackGeneral;
        defaultNs?: string | undefined;
        availableNs?: string[] | undefined;
        staticData?: import("./State/initState").TolgeeStaticDataProp | undefined;
        observerType: "invisible" | "text";
        observerOptions: import("./State/observerOptions").ObserverOptionsInternal;
        onFormatError: import("../types").OnFormatError;
        onTranslationMissing: import("../types").MissingTranslationHandler;
        fetch: import("../types").FetchFn;
        tagNewKeys?: string[] | undefined;
        filterTag?: string[] | undefined;
        autoLoadRequiredData: boolean;
    };
    removeActiveNs: (ns: NsFallback) => void;
    getRequiredNamespaces: () => string[];
    getFallbackLangs: (lang?: string | undefined) => string[];
    getFallbackNs: () => string[];
    getNs: () => string[];
    getDefaultNs: (ns?: string | undefined) => string;
    getAvailableLanguages: () => string[] | undefined;
    getAvailableNs: () => string[] | undefined;
    withDefaultNs: (descriptor: CacheDescriptor) => CacheDescriptorInternal;
    overrideCredentials: (credentials: import("../types").DevCredentials) => void;
    onPendingLanguageChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"pendingLanguage", string>>) => import("../types").Subscription;
        readonly emit: (data: string) => void;
    };
    onLanguageChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"language", string>>) => import("../types").Subscription;
        readonly emit: (data: string) => void;
    };
    onLoadingChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"loading", boolean>>) => import("../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onFetchingChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"fetching", boolean>>) => import("../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onInitialLoaded: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"initialLoad", void>>) => import("../types").Subscription;
        readonly emit: (data: void) => void;
    };
    onRunningChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"running", boolean>>) => import("../types").Subscription;
        readonly emit: (data: boolean) => void;
    };
    onCacheChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"cache", import("../types").CacheDescriptorWithKey>>) => import("../types").Subscription;
        readonly emit: (data: import("../types").CacheDescriptorWithKey) => void;
    };
    onPermanentChange: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"permanentChange", import("../types").TranslationDescriptor>>) => import("../types").Subscription;
        readonly emit: (data: import("../types").TranslationDescriptor) => void;
    };
    onError: {
        readonly listen: (handler: import("../types").Handler<import("../types").ListenerEvent<"error", import("../types").TolgeeError>>) => import("../types").Subscription;
        readonly emit: (data: import("../types").TolgeeError) => void;
    };
    onUpdate: import("./Events/EventEmitterCombined").EventEmitterCombinedInstance<import("../types").UpdateEvent>;
    setEmitterActive: (active: boolean) => void;
    on: import("../types").TolgeeOn<keyof import("../types").EventType>;
}>;
export type ControllerInstance = ReturnType<typeof Controller>;
export {};
