var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { stat } from 'fs/promises';
import { exitWithError } from './logger.js';
export function checkPathNotAFile(path) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const stats = yield stat(path);
            if (!stats.isDirectory()) {
                exitWithError('The specified path already exists and is not a directory.');
            }
        }
        catch (e) {
            // Ignore "file doesn't exist" error
            if (e.code !== 'ENOENT') {
                throw e;
            }
        }
    });
}
