var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import readline from 'readline'; // readline/promises is Node 17, currently supporting Node 16+
export function askString(question) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve) => {
            const rl = readline.createInterface({
                input: process.stdin,
                output: process.stdout,
            });
            rl.question(`${question} `, (a) => {
                resolve(a);
                rl.close();
            });
        });
    });
}
export function askBoolean(question_1) {
    return __awaiter(this, arguments, void 0, function* (question, def = false) {
        var _a;
        const yn = def === true ? '[Y/n]' : '[y/N]';
        let res = def;
        const str = yield askString(`${question} ${yn}`);
        const strRes = (_a = str[0]) === null || _a === void 0 ? void 0 : _a.toLowerCase();
        if (strRes === 'y') {
            res = true;
        }
        else if (strRes === 'n') {
            res = false;
        }
        return res;
    });
}
