var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { cosmiconfig, defaultLoaders } from 'cosmiconfig';
import { readFile } from 'fs/promises';
import { fileURLToPath } from 'url';
import { dirname, join, resolve } from 'path';
import { error, exitWithError } from '../utils/logger.js';
import { existsSync } from 'fs';
import { valueToArray } from '../utils/valueToArray.js';
import { Ajv } from 'ajv';
const explorer = cosmiconfig('tolgee', {
    loaders: {
        noExt: defaultLoaders['.json'],
    },
});
function parseConfig(input, configDir) {
    var _a, _b, _c, _d;
    const rc = Object.assign({}, input);
    if (rc.apiUrl !== undefined) {
        try {
            new URL(rc.apiUrl);
        }
        catch (_e) {
            throw new Error('Invalid config: apiUrl is an invalid URL');
        }
    }
    if (rc.projectId !== undefined) {
        rc.projectId = Number(rc.projectId); // Number("") returns 0
        if (!Number.isInteger(rc.projectId) || rc.projectId <= 0) {
            throw new Error("Invalid config: 'projectId' should be an integer representing your project Id");
        }
    }
    // convert relative paths in config to absolute
    if (rc.extractor !== undefined) {
        rc.extractor = resolve(configDir, rc.extractor).replace(/\\/g, '/');
        if (!existsSync(rc.extractor)) {
            throw new Error(`Invalid config: extractor points to a file that does not exists (${rc.extractor})`);
        }
    }
    // convert relative paths in config to absolute
    if (rc.patterns !== undefined) {
        rc.patterns = rc.patterns.map((pattern) => resolve(configDir, pattern).replace(/\\/g, '/'));
    }
    // convert relative paths in config to absolute
    if ((_a = rc.push) === null || _a === void 0 ? void 0 : _a.files) {
        rc.push.files = rc.push.files.map((r) => (Object.assign(Object.assign({}, r), { path: resolve(configDir, r.path).replace(/\\/g, '/') })));
    }
    // convert relative paths in config to absolute
    if ((_b = rc.push) === null || _b === void 0 ? void 0 : _b.filesTemplate) {
        rc.push.filesTemplate = (_c = valueToArray(rc.push.filesTemplate)) === null || _c === void 0 ? void 0 : _c.map((template) => resolve(configDir, template).replace(/\\/g, '/'));
    }
    // convert relative paths in config to absolute
    if (((_d = rc.pull) === null || _d === void 0 ? void 0 : _d.path) !== undefined) {
        rc.pull.path = resolve(configDir, rc.pull.path).replace(/\\/g, '/');
    }
    return rc;
}
function getSchema() {
    return __awaiter(this, void 0, void 0, function* () {
        const path = join(fileURLToPath(new URL('.', import.meta.url)), '..', '..', 'schema.json');
        return JSON.parse((yield readFile(path)).toString());
    });
}
export default function loadTolgeeRc(path) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        let res;
        if (path) {
            try {
                res = yield explorer.load(path);
            }
            catch (e) {
                error(e.message);
                throw new Error(`Can't open config file on path "${path}"`);
            }
        }
        else {
            res = yield explorer.search();
        }
        if (!res || res.isEmpty)
            return null;
        const config = parseConfig(res.config, dirname(path || '.'));
        const ajv = new Ajv({ allowUnionTypes: true });
        const validate = ajv.compile(yield getSchema());
        validate(config);
        const firstErr = (_a = validate.errors) === null || _a === void 0 ? void 0 : _a[0];
        if (firstErr) {
            const errMessage = `Tolgee config: '${firstErr.instancePath.replaceAll('/', '.').replace(/^\./, '')}' ${firstErr.message}`;
            exitWithError(errMessage);
        }
        return config;
    });
}
