var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Command } from 'commander';
import ansi from 'ansi-colors';
import { compareKeys, printKey } from './syncUtils.js';
import { extractKeysOfFiles, filterExtractionResult, } from '../../extractor/runner.js';
import { dumpWarnings } from '../../extractor/warnings.js';
import { loading } from '../../utils/logger.js';
import { handleLoadableError } from '../../client/TolgeeClient.js';
const asyncHandler = (config) => function () {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const opts = this.optsWithGlobals();
        const rawKeys = yield loading('Analyzing code...', extractKeysOfFiles(opts));
        dumpWarnings(rawKeys);
        const localKeys = filterExtractionResult(rawKeys);
        const loadable = yield opts.client.GET('/v2/projects/{projectId}/all-keys', { params: { path: { projectId: opts.client.getProjectId() } } });
        handleLoadableError(loadable);
        const remoteKeys = (_a = loadable.data._embedded.keys) !== null && _a !== void 0 ? _a : [];
        const diff = compareKeys(localKeys, remoteKeys);
        if (!diff.added.length && !diff.removed.length) {
            console.log(ansi.green('Your code project is in sync with the associated Tolgee project!'));
            process.exit(0);
        }
        console.log('Your code project and Tolgee project are out of sync.');
        if (diff.added.length) {
            const key = diff.added.length === 1 ? 'key' : 'keys';
            console.log(ansi.green.bold(`${diff.added.length} new ${key} found`));
            for (const key of diff.added) {
                printKey(key, false);
            }
            // Line break
            console.log('');
        }
        if (diff.removed.length) {
            const key = diff.removed.length === 1 ? 'key' : 'keys';
            console.log(ansi.red.bold(`${diff.removed.length} unused ${key}`));
            for (const key of diff.removed) {
                printKey(key, true);
            }
            // Line break
            console.log('');
        }
        console.log('Run `tolgee sync` to synchronize the projects.');
    });
};
export default (config) => new Command()
    .name('compare')
    .description('Compares the keys in your code project and in the Tolgee project.')
    .action(asyncHandler(config));
