var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { API_KEY_PAK_PREFIX } from './../constants.js';
import { handleLoadableError } from './TolgeeClient.js';
import { exitWithError } from './../utils/logger.js';
export const getApiKeyInformation = (client, key) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    if (key.startsWith(API_KEY_PAK_PREFIX)) {
        const loadable = yield client.GET('/v2/api-keys/current');
        if (loadable.response.status === 401) {
            exitWithError(`Couldn't log in: the API key you provided is invalid (${new URL(loadable.response.url).host}).`);
        }
        handleLoadableError(loadable);
        const info = loadable.data;
        const username = info.userFullName || info.username || '<unknown user>';
        return {
            type: 'PAK',
            key: key,
            username: username,
            project: {
                id: info.projectId,
                name: info.projectName,
            },
            expires: (_a = info.expiresAt) !== null && _a !== void 0 ? _a : 0,
        };
    }
    else {
        const loadable = yield client.GET('/v2/pats/current');
        if (loadable.response.status === 401) {
            exitWithError(`Couldn't log in: the API key you provided is invalid (${new URL(loadable.response.url).host}).`);
        }
        handleLoadableError(loadable);
        const info = loadable.data;
        const username = info.user.name || info.user.username;
        return {
            type: 'PAT',
            key: key,
            username: username,
            expires: (_b = info.expiresAt) !== null && _b !== void 0 ? _b : 0,
        };
    }
});
