import { AtprotoFeedService, FeedParser, } from '@dhaaga/bridge';
import { queryOptions } from '@tanstack/react-query';
export function getMyFeedListQueryOpts(client, driver, server, acctIdentifier) {
    async function api() {
        const _client = client;
        const result = await _client.me.getPreferences();
        const feeds = AtprotoFeedService.extractFeedPreferences(result);
        const feedGens = await _client.feeds.getFeedGenerators(feeds.filter((o) => o.type === 'feed').map((o) => o.value));
        return feedGens.map((o) => FeedParser.parse(o, driver, server));
    }
    return queryOptions({
        queryKey: ['dhaaga/my/feeds', acctIdentifier],
        queryFn: api,
        enabled: client !== null,
    });
}
//# sourceMappingURL=feed.js.map