import { NotificationObjectType, ResultPage, UserObjectType } from '@dhaaga/bridge';
import { Dispatch, ReactNode } from 'react';
type State = {
    seen: Set<string>;
    data: NotificationObjectType[];
    users: UserObjectType[];
    items: NotificationObjectType[];
    userSet: Set<string>;
    userSelection: Set<string>;
    allSelected: boolean;
    noneSelected: boolean;
    maxId?: string | null;
    appliedMaxId?: string | null;
    endOfPage: boolean;
};
declare enum ACTION {
    RESET = "init",
    APPEND = "append",
    SELECT_ALL = "selectAll",
    SELECT_NONE = "deselectAll",
    LOAD_NEXT_PAGE = "loadNextPage"
}
type Actions = {
    type: ACTION.RESET;
} | {
    type: ACTION.APPEND;
    payload: ResultPage<NotificationObjectType[]>;
} | {
    type: ACTION.LOAD_NEXT_PAGE;
} | {
    type: ACTION.SELECT_ALL;
} | {
    type: ACTION.SELECT_NONE;
};
type DispatchType = Dispatch<Actions>;
declare const useSubscriptionGalleryState: () => State | null;
declare const useSubscriptionGalleryDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as SubscriptionGalleryCtx, useSubscriptionGalleryState, useSubscriptionGalleryDispatch, ACTION as SubscriptionGalleryStateAction, };
export type { State as SubscriptionGalleryStateType, DispatchType as SubscriptionGalleryDispatchType, };
//# sourceMappingURL=subscription-gallery.d.ts.map