import { jsx as _jsx } from "react/jsx-runtime";
import { createContext, useContext, useReducer, } from 'react';
import { postThreadInterfaceToObjectChain, } from '@dhaaga/bridge';
import { produce } from 'immer';
const DEFAULT = {
    lookup: new Map(),
    children: new Map(),
    history: [],
    anchor: null,
};
var ACTION;
(function (ACTION) {
    ACTION["RESET"] = "init";
    ACTION["SETUP"] = "setup";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.RESET: {
            return produce(state, (draft) => {
                draft.anchor = null;
                draft.history = [];
                draft.lookup.clear();
                draft.children.clear();
            });
        }
        case ACTION.SETUP: {
            const chainData = action.payload.chainData;
            const anchor = action.payload.anchor;
            const client = action.payload.client;
            const { history, itemLookup, childrenLookup } = postThreadInterfaceToObjectChain(chainData, client, anchor);
            return produce(state, (draft) => {
                draft.anchor = anchor;
                draft.history = history;
                draft.lookup = itemLookup;
                draft.children = childrenLookup;
            });
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const usePostThreadState = () => useContext(StateCtx);
const usePostThreadDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as PostThreadCtx, usePostThreadState, usePostThreadDispatch, ACTION as PostThreadAction, };
//# sourceMappingURL=post-thread.js.map