import { Dispatch, ReactNode } from 'react';
import { ApiTargetInterface, type DhaagaPostThreadInterfaceType, type PostObjectType } from '@dhaaga/bridge';
type State = {
    lookup: Map<string, PostObjectType>;
    children: Map<string, string[]>;
    history: PostObjectType[];
    anchor: PostObjectType | null;
};
declare enum ACTION {
    RESET = "init",
    SETUP = "setup"
}
type Actions = {
    type: ACTION.RESET;
} | {
    type: ACTION.SETUP;
    payload: {
        anchor: PostObjectType;
        client: ApiTargetInterface;
        chainData: DhaagaPostThreadInterfaceType;
    };
};
type DispatchType = Dispatch<Actions>;
declare const usePostThreadState: () => State | null;
declare const usePostThreadDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as PostThreadCtx, usePostThreadState, usePostThreadDispatch, ACTION as PostThreadAction, };
export type { State as PostThreadStateType, DispatchType as PostThreadDispatchType, };
//# sourceMappingURL=post-thread.d.ts.map