import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
const defaultSuggestions = {
    accounts: [],
    hashtags: [],
    emojis: [],
};
var ACTION;
(function (ACTION) {
    ACTION[ACTION["SET_MODE_TEXT"] = 0] = "SET_MODE_TEXT";
    ACTION[ACTION["SET_MODE_EMOJI"] = 1] = "SET_MODE_EMOJI";
    ACTION[ACTION["SET_MODE_MEDIA"] = 2] = "SET_MODE_MEDIA";
    ACTION[ACTION["SWITCH_TO_EMOJI_TAB"] = 3] = "SWITCH_TO_EMOJI_TAB";
    ACTION[ACTION["SWITCH_TO_TEXT_TAB"] = 4] = "SWITCH_TO_TEXT_TAB";
    ACTION[ACTION["SWITCH_TO_MEDIA_TAB"] = 5] = "SWITCH_TO_MEDIA_TAB";
    ACTION[ACTION["SET_TEXT"] = 6] = "SET_TEXT";
    ACTION[ACTION["CLEAR_TEXT"] = 7] = "CLEAR_TEXT";
    ACTION[ACTION["SET_CW"] = 8] = "SET_CW";
    ACTION[ACTION["TOGGLE_CW_SECTION_SHOWN"] = 9] = "TOGGLE_CW_SECTION_SHOWN";
    ACTION[ACTION["SHOW_CW_SECTION"] = 10] = "SHOW_CW_SECTION";
    ACTION[ACTION["HIDE_CW_SECTION"] = 11] = "HIDE_CW_SECTION";
    ACTION[ACTION["ADD_MEDIA"] = 12] = "ADD_MEDIA";
    ACTION[ACTION["REMOVE_MEDIA"] = 13] = "REMOVE_MEDIA";
    ACTION[ACTION["SET_UPLOAD_STATUS"] = 14] = "SET_UPLOAD_STATUS";
    ACTION[ACTION["UPDATE_CW_STATUS"] = 15] = "UPDATE_CW_STATUS";
    ACTION[ACTION["SET_REMOTE_CONTENT"] = 16] = "SET_REMOTE_CONTENT";
    ACTION[ACTION["SET_PARENT"] = 17] = "SET_PARENT";
    ACTION[ACTION["SET_SEARCH_PROMPT"] = 18] = "SET_SEARCH_PROMPT";
    ACTION[ACTION["CLEAR_SEARCH_PROMPT"] = 19] = "CLEAR_SEARCH_PROMPT";
    ACTION[ACTION["SET_VISIBILITY"] = 20] = "SET_VISIBILITY";
    ACTION[ACTION["QUOTES_SET_ALLOWED"] = 21] = "QUOTES_SET_ALLOWED";
    ACTION[ACTION["QUOTES_SET_BLOCKED"] = 22] = "QUOTES_SET_BLOCKED";
    ACTION[ACTION["THREADGATE_SET_ALL"] = 23] = "THREADGATE_SET_ALL";
    ACTION[ACTION["THREADGATE_SET_NONE"] = 24] = "THREADGATE_SET_NONE";
    ACTION[ACTION["THREADGATE_SET_MENTIONED"] = 25] = "THREADGATE_SET_MENTIONED";
    ACTION[ACTION["THREADGATE_SET_FOLLOWERS"] = 26] = "THREADGATE_SET_FOLLOWERS";
    ACTION[ACTION["THREADGATE_SET_FOLLOWEES"] = 27] = "THREADGATE_SET_FOLLOWEES";
    ACTION[ACTION["SET_KEYBOARD_SELECTION"] = 28] = "SET_KEYBOARD_SELECTION";
    ACTION[ACTION["SET_SUGGESTION"] = 29] = "SET_SUGGESTION";
    ACTION[ACTION["CLEAR_SUGGESTION"] = 30] = "CLEAR_SUGGESTION";
    ACTION[ACTION["SET_ALT_TEXT"] = 31] = "SET_ALT_TEXT";
    ACTION[ACTION["SET_ALT_TEXT_SYNC_STATUS"] = 32] = "SET_ALT_TEXT_SYNC_STATUS";
})(ACTION || (ACTION = {}));
const DEFAULT = {
    mode: 'txt',
    prompt: {
        q: '',
        type: 'none',
    },
    cw: null,
    isCwVisible: false,
    medias: [],
    text: null,
    visibility: 'public',
    parent: null,
    isQuote: false,
    keyboardSelection: {
        start: 0,
        end: 0,
    },
    suggestions: defaultSuggestions,
    threadGates: [],
    allowQuotes: true,
};
function reducer(state, action) {
    switch (action.type) {
        case ACTION.SET_MODE_TEXT: {
            return produce(state, (draft) => {
                draft.mode = 'txt';
            });
        }
        case ACTION.SET_MODE_EMOJI: {
            return produce(state, (draft) => {
                draft.mode = 'emoji';
            });
        }
        case ACTION.SET_MODE_MEDIA: {
            return produce(state, (draft) => {
                draft.mode = 'media';
            });
        }
        case ACTION.SET_TEXT: {
            return produce(state, (draft) => {
                draft.text = action.payload.content;
            });
        }
        case ACTION.CLEAR_TEXT: {
            return produce(state, (draft) => {
                draft.text = null;
            });
        }
        case ACTION.SWITCH_TO_EMOJI_TAB: {
            return produce(state, (draft) => {
                draft.mode = 'emoji';
            });
        }
        case ACTION.SWITCH_TO_TEXT_TAB: {
            return produce(state, (draft) => {
                draft.mode = 'txt';
            });
        }
        case ACTION.SWITCH_TO_MEDIA_TAB: {
            return produce(state, (draft) => {
                draft.mode = 'media';
            });
        }
        case ACTION.SET_VISIBILITY: {
            return produce(state, (draft) => {
                draft.visibility = action.payload.visibility;
            });
        }
        case ACTION.TOGGLE_CW_SECTION_SHOWN: {
            return produce(state, (draft) => {
                draft.isCwVisible = !draft.isCwVisible;
            });
        }
        case ACTION.SHOW_CW_SECTION: {
            return produce(state, (draft) => {
                draft.isCwVisible = true;
            });
        }
        case ACTION.HIDE_CW_SECTION: {
            return produce(state, (draft) => {
                draft.isCwVisible = false;
            });
        }
        case ACTION.SET_PARENT: {
            return produce(state, (draft) => {
                draft.parent = action.payload.item;
            });
        }
        case ACTION.SET_SEARCH_PROMPT: {
            return produce(state, (draft) => {
                draft.prompt = action.payload;
            });
        }
        case ACTION.CLEAR_SEARCH_PROMPT: {
            return produce(state, (draft) => {
                draft.prompt = {
                    type: 'none',
                    q: '',
                };
            });
        }
        case ACTION.SET_KEYBOARD_SELECTION: {
            return produce(state, (draft) => {
                draft.keyboardSelection = action.payload;
            });
        }
        case ACTION.SET_CW: {
            return produce(state, (draft) => {
                draft.cw = action.payload.content;
            });
        }
        case ACTION.SET_SUGGESTION: {
            return produce(state, (draft) => {
                draft.suggestions = action.payload;
            });
        }
        case ACTION.CLEAR_SUGGESTION: {
            return produce(state, (draft) => {
                draft.suggestions = defaultSuggestions;
            });
        }
        case ACTION.ADD_MEDIA: {
            return produce(state, (draft) => {
                draft.medias.push({
                    status: 'idle',
                    altSyncStatus: 'idle',
                    previewUrl: null,
                    remoteId: null,
                    url: null,
                    localUri: action.payload.item.uri,
                    localAlt: null,
                    remoteAlt: null,
                    mimeType: action.payload.item.mimeType,
                });
            });
        }
        case ACTION.SET_ALT_TEXT: {
            const _index = action.payload.index;
            const _text = action.payload.text;
            if (state.medias.length <= _index)
                return state;
            return produce(state, (draft) => {
                draft.medias[_index].localAlt = !_text ? null : _text;
                draft.medias[_index].altSyncStatus = 'idle';
            });
        }
        case ACTION.SET_ALT_TEXT_SYNC_STATUS: {
            const _index = action.payload.index;
            const _status = action.payload.status;
            if (state.medias.length <= _index)
                return state;
            return produce(state, (draft) => {
                draft.medias[_index].altSyncStatus = _status;
                if (_status === 'uploaded') {
                    draft.medias[_index].remoteAlt = state.medias[_index].localAlt;
                }
            });
        }
        case ACTION.REMOVE_MEDIA: {
            const _index = action.payload.index;
            return produce(state, (draft) => {
                draft.medias = [
                    ...draft.medias.slice(0, _index),
                    ...draft.medias.slice(_index + 1),
                ];
            });
        }
        case ACTION.SET_REMOTE_CONTENT: {
            const _index = state.medias.findIndex((o) => o.localUri === action.payload.localUri);
            if (_index === -1)
                return state;
            return produce(state, (draft) => {
                draft.medias[_index].remoteId = action.payload.remoteId;
                draft.medias[_index].previewUrl = action.payload.previewUrl;
            });
        }
        case ACTION.SET_UPLOAD_STATUS: {
            const _index = state.medias.findIndex((o) => o.localUri === action.payload.localUri);
            if (_index === -1)
                return state;
            return produce(state, (draft) => {
                draft.medias[_index].status = action.payload.status;
            });
        }
        case ACTION.QUOTES_SET_ALLOWED: {
            return produce(state, (draft) => {
                draft.allowQuotes = true;
            });
        }
        case ACTION.QUOTES_SET_BLOCKED: {
            return produce(state, (draft) => {
                draft.allowQuotes = false;
            });
        }
        case ACTION.THREADGATE_SET_ALL: {
            return produce(state, (draft) => {
                draft.threadGates = [];
            });
        }
        case ACTION.THREADGATE_SET_NONE: {
            return produce(state, (draft) => {
                draft.threadGates = ['nobody'];
            });
        }
        case ACTION.THREADGATE_SET_MENTIONED: {
            return produce(state, (draft) => {
                draft.threadGates = draft.threadGates.includes('nobody')
                    ? ['mentioned']
                    : [...draft.threadGates, 'mentioned'];
            });
        }
        case ACTION.THREADGATE_SET_FOLLOWERS: {
            return produce(state, (draft) => {
                draft.threadGates = draft.threadGates.includes('nobody')
                    ? ['followers']
                    : [...draft.threadGates, 'followers'];
            });
        }
        case ACTION.THREADGATE_SET_FOLLOWEES: {
            return produce(state, (draft) => {
                draft.threadGates = draft.threadGates.includes('nobody')
                    ? ['following']
                    : [...draft.threadGates, 'following'];
            });
        }
        default: {
            return state;
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const usePostComposerState = () => useContext(StateCtx);
const usePostComposerDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as PostComposerCtx, usePostComposerState, usePostComposerDispatch, ACTION as PostComposerAction, };
//# sourceMappingURL=composer.js.map