import type { PostObjectType } from '@dhaaga/bridge';
import type { CustomEmojiObjectType, TagTargetInterface, UserObjectType } from '@dhaaga/bridge';
import { Dispatch, ReactNode } from 'react';
import type { ImagePickerAsset } from 'expo-image-picker';
type SearchPrompt = {
    q: string;
    type: 'acct' | 'tag' | 'emoji' | 'none';
};
export type PostComposerMediaAttachmentState = {
    status: 'idle' | 'uploading' | 'uploaded' | 'failed';
    altSyncStatus: 'idle' | 'uploading' | 'uploaded' | 'failed';
    previewUrl: string | null;
    remoteId: string | null;
    url: string | null;
    localUri: string;
    localAlt: string | null;
    remoteAlt: string | null;
    mimeType?: string;
};
type AutoFillResultsType = {
    accounts: UserObjectType[];
    hashtags: TagTargetInterface[];
    emojis: CustomEmojiObjectType[];
};
type VisibilityEntry = 'public' | 'home' | 'direct' | 'followers';
type ThreadGateEntry = 'nobody' | 'following' | 'followers' | 'mentioned';
type State = {
    mode: 'txt' | 'emoji' | 'media';
    text: string | null;
    prompt: SearchPrompt;
    cw: string | null;
    isCwVisible: boolean;
    medias: PostComposerMediaAttachmentState[];
    keyboardSelection: {
        start: number;
        end: number;
    };
    visibility: 'public' | 'home' | 'direct' | 'followers';
    parent: PostObjectType | null;
    isQuote: boolean;
    suggestions: AutoFillResultsType;
    threadGates: ThreadGateEntry[];
    allowQuotes: boolean;
};
declare enum ACTION {
    SET_MODE_TEXT = 0,
    SET_MODE_EMOJI = 1,
    SET_MODE_MEDIA = 2,
    SWITCH_TO_EMOJI_TAB = 3,
    SWITCH_TO_TEXT_TAB = 4,
    SWITCH_TO_MEDIA_TAB = 5,
    SET_TEXT = 6,
    CLEAR_TEXT = 7,
    SET_CW = 8,
    TOGGLE_CW_SECTION_SHOWN = 9,
    SHOW_CW_SECTION = 10,
    HIDE_CW_SECTION = 11,
    ADD_MEDIA = 12,
    REMOVE_MEDIA = 13,
    SET_UPLOAD_STATUS = 14,
    UPDATE_CW_STATUS = 15,
    SET_REMOTE_CONTENT = 16,
    SET_PARENT = 17,
    SET_SEARCH_PROMPT = 18,
    CLEAR_SEARCH_PROMPT = 19,
    SET_VISIBILITY = 20,
    QUOTES_SET_ALLOWED = 21,
    QUOTES_SET_BLOCKED = 22,
    THREADGATE_SET_ALL = 23,
    THREADGATE_SET_NONE = 24,
    THREADGATE_SET_MENTIONED = 25,
    THREADGATE_SET_FOLLOWERS = 26,
    THREADGATE_SET_FOLLOWEES = 27,
    SET_KEYBOARD_SELECTION = 28,
    SET_SUGGESTION = 29,
    CLEAR_SUGGESTION = 30,
    SET_ALT_TEXT = 31,
    SET_ALT_TEXT_SYNC_STATUS = 32
}
type Actions = {
    type: ACTION.SET_MODE_TEXT;
} | {
    type: ACTION.SET_MODE_EMOJI;
} | {
    type: ACTION.SET_MODE_MEDIA;
} | {
    type: ACTION.SET_TEXT;
    payload: {
        content: string;
    };
} | {
    type: ACTION.CLEAR_TEXT;
} | {
    type: ACTION.SWITCH_TO_MEDIA_TAB;
} | {
    type: ACTION.SWITCH_TO_EMOJI_TAB;
} | {
    type: ACTION.SWITCH_TO_TEXT_TAB;
} | {
    type: ACTION.SET_VISIBILITY;
    payload: {
        visibility: VisibilityEntry;
    };
} | {
    type: ACTION.TOGGLE_CW_SECTION_SHOWN;
} | {
    type: ACTION.SHOW_CW_SECTION;
} | {
    type: ACTION.HIDE_CW_SECTION;
} | {
    type: ACTION.SET_PARENT;
    payload: {
        item: PostObjectType;
    };
} | {
    type: ACTION.SET_SEARCH_PROMPT;
    payload: SearchPrompt;
} | {
    type: ACTION.SET_KEYBOARD_SELECTION;
    payload: {
        start: number;
        end: number;
    };
} | {
    type: ACTION.SET_CW;
    payload: {
        content: string;
    };
} | {
    type: ACTION.SET_SUGGESTION;
    payload: AutoFillResultsType;
} | {
    type: ACTION.CLEAR_SUGGESTION;
} | {
    type: ACTION.ADD_MEDIA;
    payload: {
        item: ImagePickerAsset;
    };
} | {
    type: ACTION.SET_UPLOAD_STATUS;
    payload: {
        localUri: string;
        status: 'idle' | 'uploading' | 'uploaded' | 'failed';
    };
} | {
    type: ACTION.UPDATE_CW_STATUS;
} | {
    type: ACTION.SET_ALT_TEXT;
    payload: {
        index: number;
        text: string;
    };
} | {
    type: ACTION.SET_ALT_TEXT_SYNC_STATUS;
    payload: {
        index: number;
        status: 'uploading' | 'uploaded' | 'failed';
    };
} | {
    type: ACTION.REMOVE_MEDIA;
    payload: {
        index: number;
    };
} | {
    type: ACTION.SET_REMOTE_CONTENT;
    payload: {
        localUri: string;
        remoteId: string;
        previewUrl: string;
    };
} | {
    type: ACTION.CLEAR_SEARCH_PROMPT;
} | {
    type: ACTION.QUOTES_SET_ALLOWED;
} | {
    type: ACTION.QUOTES_SET_BLOCKED;
} | {
    type: ACTION.THREADGATE_SET_ALL;
} | {
    type: ACTION.THREADGATE_SET_NONE;
} | {
    type: ACTION.THREADGATE_SET_MENTIONED;
} | {
    type: ACTION.THREADGATE_SET_FOLLOWERS;
} | {
    type: ACTION.THREADGATE_SET_FOLLOWEES;
};
type DispatchType = Dispatch<Actions>;
declare const usePostComposerState: () => State | null;
declare const usePostComposerDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as PostComposerCtx, usePostComposerState, usePostComposerDispatch, ACTION as PostComposerAction, };
export type { State as PostComposerStateType, DispatchType as PostComposerDispatchType, };
//# sourceMappingURL=composer.d.ts.map