import { ChatRoomObjectType, MessageObjectType, ResultPage } from '@dhaaga/bridge';
import { Dispatch, ReactNode } from 'react';
type State = {
    items: MessageObjectType[];
    roomData: ChatRoomObjectType | null;
    minId?: string | null;
    maxId?: string | null;
    seen: Set<string>;
};
declare enum ACTION {
    RESET = "init",
    SET_ROOM_DATA = "setRoomData",
    APPEND_PAGE = "append_PAGE",
    APPEND_MESSAGE = "append_MESSAGE"
}
type Actions = {
    type: ACTION.RESET;
} | {
    type: ACTION.SET_ROOM_DATA;
    payload: {
        roomData: ChatRoomObjectType;
    };
} | {
    type: ACTION.APPEND_PAGE;
    payload: ResultPage<MessageObjectType[]>;
} | {
    type: ACTION.APPEND_MESSAGE;
    payload: MessageObjectType;
};
type DispatchType = Dispatch<Actions>;
declare const useChatroomState: () => State;
declare const useChatroomDispatch: () => DispatchType;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as ChatroomCtx, useChatroomState, useChatroomDispatch, ACTION as ChatroomStateAction, };
export type { State as PostTimelineStateType, DispatchType as PostTimelineDispatchType, };
//# sourceMappingURL=chatroom.d.ts.map