import { useState } from 'react';
import { AtProtoAuthService } from '@dhaaga/bridge/auth';
import { Agent, } from '@atproto/api';
function useAtProtoAuth(serviceUrl = 'https://bsky.social') {
    const [Username, setUsername] = useState(null);
    const [Password, setPassword] = useState(null);
    const [ServiceUrl, setServiceUrl] = useState(serviceUrl);
    const [IsLoading, setIsLoading] = useState(false);
    const [UserData, setUserData] = useState(null);
    const [SessionData, setSessionData] = useState(null);
    const [AuthCompleted, setAuthCompleted] = useState(false);
    function reset() {
        setAuthCompleted(false);
        setUserData(null);
        setSessionData(null);
    }
    async function authenticate() {
        setIsLoading(true);
        if (!Username || !Password)
            return null;
        try {
            const result = await AtProtoAuthService.loginWithPassword(Username, Password, ServiceUrl);
            if (!result)
                return null;
            const { sessionData, session } = result;
            setSessionData(sessionData);
            const agent = new Agent(session);
            const profileData = await agent.getProfile({ actor: sessionData.did });
            setUserData(profileData);
            setAuthCompleted(true);
            return { profileData, sessionData };
        }
        catch (e) {
            return null;
        }
    }
    return {
        username: Username,
        setUsername,
        password: Password,
        setPassword,
        serviceUrl: ServiceUrl,
        setServiceUrl,
        completed: AuthCompleted,
        loading: IsLoading,
        userData: UserData,
        sessionData: SessionData,
        authenticate,
        reset,
    };
}
export default useAtProtoAuth;
//# sourceMappingURL=useAtProtoAuth.js.map