var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { KnownServer } from '../_schema.js';
import { DbErrorHandler } from './_base.repo.js';
import { KNOWN_SOFTWARE } from '@dhaaga/bridge';
import { DataSource } from '../dataSource.js';
import { RandomUtil } from '@dhaaga/bridge';
export { SERVER_METADATA_KEY };
var SERVER_METADATA_KEY;
(function (SERVER_METADATA_KEY) {
    SERVER_METADATA_KEY["DESCRIPTION"] = "description";
    SERVER_METADATA_KEY["SERVER_NAME"] = "serverName";
    SERVER_METADATA_KEY["SERVER_SOFTWARE"] = "serverSoftware";
    SERVER_METADATA_KEY["SOFTWARE_VERSION"] = "softwareVersion";
    SERVER_METADATA_KEY["ICON_URL"] = "iconUrl";
    SERVER_METADATA_KEY["FAVICON_URL"] = "faviconUrl";
    SERVER_METADATA_KEY["THEME_COLOR"] = "themeColor";
    SERVER_METADATA_KEY["NODEINFO"] = "nodeInfo";
    SERVER_METADATA_KEY["NODEINFO_LAST_FETCHED_AT"] = "nodeInfoLastFetchedAt";
    SERVER_METADATA_KEY["NODEINFO_LAST_ATTEMPT_AT"] = "nodeinfoLastAttemptAt";
    SERVER_METADATA_KEY["CUSTOM_EMOJIS_LAST_FETCHED_AT"] = "customEmojisLastFetchedAt";
    SERVER_METADATA_KEY["CUSTOM_EMOJIS_LAST_ATTEMPT_AT"] = "customEmojisLastAttemptAt";
    SERVER_METADATA_KEY["CUSTOM_EMOJIS_FETCH_RETRY_COUNT"] = "customEmojisFetchRetryCount";
})(SERVER_METADATA_KEY || (SERVER_METADATA_KEY = {}));
let Repo = class Repo {
    static findByProfileAndUrl(db, server) {
        return db.knownServer.findOne({
            server,
        });
    }
    static upsert(db, input) {
        const conflict = Repo.findByProfileAndUrl(db, input.url);
        if (conflict) {
            Repo.updateDriver(db, conflict.id, input.driver);
        }
        else {
            db.knownServer.insert({
                uuid: RandomUtil.nanoId(),
                server: input.url,
                driver: input.driver,
            });
        }
        return Repo.findByProfileAndUrl(db, input.url);
    }
    static updateDriver(db, id, driver) {
        db.knownServer.update({ id }, {
            driver,
        });
    }
    static upsertMeta(db, id, input) {
        const conflict = db.knownServerMetadata.findOne({
            knownServerId: id,
            key: input.key,
        });
        if (conflict) {
            db.knownServerMetadata.updateById(conflict.id, {
                value: input.value,
                type: 'string',
            });
        }
        else {
            db.knownServerMetadata.insert(input);
        }
    }
};
Repo = __decorate([
    DbErrorHandler()
], Repo);
class Service {
    static upsertMeta(db, server, data) {
        return Repo.upsertMeta(db, server.id, data);
    }
    static upsert(db, input) {
        return Repo.upsert(db, input);
    }
    static getByUrl(db, url) {
        url = url.replace(/^https?:\/\//, '');
        return Repo.findByProfileAndUrl(db, url);
    }
    static updateDriver(db, server, driver) {
        return Repo.updateDriver(db, server.id, driver.toString());
    }
}
export { Repo as KnownServerRepo, Service as KnownServerService };
//# sourceMappingURL=server.js.map