import { KnownServer } from '../_schema.js';
import { KNOWN_SOFTWARE } from '@dhaaga/bridge';
import { DataSource } from '../dataSource.js';
export type ServerRecordType = {
    driver: string;
    url: string;
};
export declare enum SERVER_METADATA_KEY {
    DESCRIPTION = "description",
    SERVER_NAME = "serverName",
    SERVER_SOFTWARE = "serverSoftware",
    SOFTWARE_VERSION = "softwareVersion",
    ICON_URL = "iconUrl",
    FAVICON_URL = "faviconUrl",
    THEME_COLOR = "themeColor",
    NODEINFO = "nodeInfo",
    NODEINFO_LAST_FETCHED_AT = "nodeInfoLastFetchedAt",
    NODEINFO_LAST_ATTEMPT_AT = "nodeinfoLastAttemptAt",
    CUSTOM_EMOJIS_LAST_FETCHED_AT = "customEmojisLastFetchedAt",
    CUSTOM_EMOJIS_LAST_ATTEMPT_AT = "customEmojisLastAttemptAt",
    CUSTOM_EMOJIS_FETCH_RETRY_COUNT = "customEmojisFetchRetryCount"
}
export type ProfileKnownServerMetadataRecordType = {
    key: string;
    value: string;
    type: 'string';
};
declare class Repo {
    static findByProfileAndUrl(db: DataSource, server: string): KnownServer | null;
    static upsert(db: DataSource, input: ServerRecordType): KnownServer | null;
    static updateDriver(db: DataSource, id: number, driver: string): void;
    static upsertMeta(db: DataSource, id: number, input: ProfileKnownServerMetadataRecordType): void;
}
declare class Service {
    static upsertMeta(db: DataSource, server: KnownServer, data: ProfileKnownServerMetadataRecordType): void;
    static upsert(db: DataSource, input: ServerRecordType): KnownServer | null;
    static getByUrl(db: DataSource, url: string): KnownServer | null;
    static updateDriver(db: DataSource, server: KnownServer, driver: KNOWN_SOFTWARE | string): void;
}
export { Repo as KnownServerRepo, Service as KnownServerService };
//# sourceMappingURL=server.d.ts.map