import { DataSource } from '../dataSource.js';
import { Account, Profile, ProfilePinnedUser } from '../_schema.js';
import { z } from 'zod';
import type { UserObjectType } from '@dhaaga/bridge';
import { APP_PINNED_OBJECT_TYPE } from '../types/db.types.js';
declare const profileUserPinCreateSchema: z.ZodObject<{
    server: z.ZodString;
    driver: z.ZodString;
    required: z.ZodBoolean;
    category: z.ZodEnum<{
        apProto_microBlog_USER_Local: APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_USER_LOCAL;
        apProto_microBlog_USER_Remote: APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_USER_REMOTE;
    }>;
    identifier: z.ZodString;
    username: z.ZodString;
    avatarUrl: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    displayName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>;
export type ProfileUserPinCreateType = z.infer<typeof profileUserPinCreateSchema>;
declare class Repo {
    static addLocalPin(db: DataSource, profile: Profile, acct: Account, user: UserObjectType): ProfilePinnedUser | null;
}
export declare class Service {
    static toggle(db: DataSource, pinnedUser: ProfilePinnedUser): ProfilePinnedUser | null | undefined;
    static listByUserId(db: DataSource, server: string, userId: string): ProfilePinnedUser[];
    static findById(db: DataSource, id: number): ProfilePinnedUser | null;
    static getOwnerAccount(db: DataSource, profile: Profile): Account | null;
    static find(db: DataSource, profile: Profile, server: string, userId: string): ProfilePinnedUser | null;
    static setActive(db: DataSource, profile: ProfilePinnedUser): void;
    static isPinnedForProfile(db: DataSource, profile: Profile, server: string, userId: string): boolean | null;
    static addForProfile(db: DataSource, profile: Profile, acct: Account, user: UserObjectType): ProfilePinnedUser | null;
    static getShownForProfile(db: DataSource, profile: Profile): ProfilePinnedUser[];
    static toggleUserPin(db: DataSource, profile: Profile, acct: Account, user: UserObjectType): ProfilePinnedUser | null;
}
export { Service as ProfilePinnedUserService, Repo as ProfilePinnedUserRepo };
//# sourceMappingURL=profile-pinned-user.d.ts.map