var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { DbErrorHandler } from './_base.repo.js';
import { DataSource } from '../dataSource.js';
import { Account, Profile, ProfilePinnedTag } from '../_schema.js';
import { ProfileService } from './profile.js';
import { RandomUtil } from '@dhaaga/bridge';
import { APP_PINNED_OBJECT_TYPE } from '../types/db.types.js';
let Repo = class Repo {
};
Repo = __decorate([
    DbErrorHandler()
], Repo);
class Service {
    static listByName(db, name) {
        return db.profilePinnedTag.find({
            name: name,
            active: true,
        });
    }
    static delete(db, id) {
        const match = Service.findById(db, id);
        if (match)
            db.profilePinnedTag.updateById(id, { active: false });
    }
    static add(db, acct, profile, name) {
        if (!name)
            return;
        const _uuid = RandomUtil.nanoId();
        db.profilePinnedTag.insert({
            uuid: _uuid,
            server: acct.server,
            category: APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_TAG_LOCAL,
            driver: acct.driver,
            required: true,
            show: true,
            itemOrder: 0,
            page: 1,
            unseenCount: 0,
            active: true,
            identifier: name,
            name: name,
            profileId: profile.id,
        });
        return db.profilePinnedTag.findOne({ uuid: _uuid });
    }
    static renameById(db, id, name) {
        const match = Service.findById(db, id);
        if (!match)
            return null;
        db.profilePinnedTag.updateById(match.id, {
            alias: name,
            name: name,
        });
        return Service.findById(db, id);
    }
    static findById(db, id) {
        return db.profilePinnedTag.findOne({ id });
    }
    static getShownForProfile(db, profile) {
        if (!db || !profile)
            return [];
        try {
            const items = db.profilePinnedTag.find({
                profileId: profile.id,
                active: true,
                show: true,
            });
            return items.sort((a, b) => (a.itemOrder > b.itemOrder ? 1 : -1));
        }
        catch (e) {
            return [];
        }
    }
    static upsertDefaultTags(db, profile) {
        const acct = ProfileService.getOwnerAccount(db, profile);
        if (!acct)
            return;
        const recommendedTags = ['DhaagaApp', 'DhaagaUpdates', 'DhaagaDev'];
        const currentTags = db.profilePinnedTag.find({
            profileId: profile.id,
            active: true,
        });
        for (const tag of recommendedTags) {
            if (!currentTags.find((o) => o.name === tag && o.server === acct.server)) {
                db.profilePinnedTag.insert({
                    uuid: RandomUtil.nanoId(),
                    server: acct.server,
                    category: APP_PINNED_OBJECT_TYPE.AP_PROTO_MICROBLOG_TAG_LOCAL,
                    driver: acct.driver,
                    required: true,
                    show: true,
                    itemOrder: 0,
                    page: 1,
                    unseenCount: 0,
                    active: true,
                    identifier: tag,
                    name: tag,
                    profileId: profile.id,
                });
            }
        }
        Service._fixItemOrder(db, profile);
    }
    static _fixItemOrder(db, profile) {
        try {
            let all = db.profilePinnedTag.find({
                profileId: profile.id,
                active: true,
            });
            all = all.sort((a, b) => a.id - b.id);
            let prev = -1;
            for (let i = 0; i < all.length; i++) {
                if (all[i].itemOrder <= prev) {
                    db.profilePinnedTag.updateById(all[i].id, {
                        itemOrder: prev + 1,
                    });
                    prev = prev + 1;
                }
            }
        }
        catch (e) {
            console.log('[WARN]: failed to fix item ordering for profile tags', profile.id, e);
        }
    }
}
export { Service as ProfilePinnedTagService, Repo as ProfilePinnedTagRepo };
//# sourceMappingURL=profile-pinned-tag.js.map