import * as SQLite from 'expo-sqlite';
const APP_DB = 'app.db';
const TABLE_NAME = 'migrations';
export class MigrationRepo {
    static describe() {
        const db = SQLite.openDatabaseSync(APP_DB);
        const result = db.getAllSync(`PRAGMA table_info(${TABLE_NAME});`);
    }
    static list(opts = { limit: 10, offset: 0 }) {
        const db = SQLite.openDatabaseSync(APP_DB);
        return db.getAllSync(`SELECT * FROM ${TABLE_NAME} ORDER BY userVersion DESC LIMIT ? OFFSET ?;`, opts.limit || 10, opts.offset || 0);
    }
}
//# sourceMappingURL=migrations.js.map