import { RepoTemplate } from './_base.repo.js';
import { Account, AccountSavedUser } from '../_schema.js';
import { DataSource } from '../dataSource.js';
import { RandomUtil } from '@dhaaga/bridge';
class Repo {
}
class Service {
    static getByIdentifier(db, identifier) {
        return db.accountSavedUser.findOne({
            identifier,
            active: true,
        });
    }
    static getById(db, id) {
        return db.accountSavedUser.findOne({
            id,
            active: true,
        });
    }
    static upsert(db, acct, user) {
        const conflict = db.accountSavedUser.findOne({
            active: true,
            identifier: user.id,
        });
        if (conflict) {
            db.accountSavedUser.updateById(conflict.id, {
                identifier: user.id,
                remoteServer: user.instance,
                avatarUrl: user.avatarUrl,
                displayName: user.displayName,
                username: user.handle,
                accountId: acct.id,
                isRemote: false,
                active: true,
            });
        }
        else {
            db.accountSavedUser.insert({
                uuid: RandomUtil.nanoId(),
                identifier: user.id,
                remoteServer: user.instance,
                avatarUrl: user.avatarUrl,
                displayName: user.displayName,
                username: user.handle,
                accountId: acct.id,
                isRemote: false,
                active: true,
            });
        }
        return db.accountSavedUser.findOne({
            identifier: user.id,
        });
    }
}
export { Repo as AccountSavedUserRepo, Service as AccountSavedUserService };
//# sourceMappingURL=account-saved-user.js.map