var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { z } from 'zod';
import { DbErrorHandler, RepoTemplate } from './_base.repo.js';
import { Account, AccountMetadata } from '../_schema.js';
import { DataSource } from '../dataSource.js';
export const accountMetadataRecordDto = z.object({
    key: z.string(),
    value: z.string(),
    type: z.string(),
});
export const accountMetadataUpsertDto = accountMetadataRecordDto.extend({
    accountId: z.number().optional(),
});
export { ACCOUNT_METADATA_KEY };
var ACCOUNT_METADATA_KEY;
(function (ACCOUNT_METADATA_KEY) {
    ACCOUNT_METADATA_KEY["USER_IDENTIFIER"] = "userIdentifier";
    ACCOUNT_METADATA_KEY["AVATAR_URL"] = "avatarUrl";
    ACCOUNT_METADATA_KEY["DISPLAY_NAME"] = "displayName";
    ACCOUNT_METADATA_KEY["ACCESS_TOKEN"] = "accessToken";
    ACCOUNT_METADATA_KEY["REFRESH_TOKEN"] = "refreshToken";
    ACCOUNT_METADATA_KEY["ATPROTO_SESSION_OBJECT"] = "atprotoSessionObject";
    ACCOUNT_METADATA_KEY["ATPROTO_DID"] = "atprotoDid";
    ACCOUNT_METADATA_KEY["ATPROTO_APP_PASSWORD"] = "atprotoAppPassword";
    ACCOUNT_METADATA_KEY["ATPROTO_SESSION"] = "atprotoSession";
})(ACCOUNT_METADATA_KEY || (ACCOUNT_METADATA_KEY = {}));
let Repo = class Repo {
    static getAllKeysForAccount(db, accountId) {
        return db.accountMetadata.find({
            accountId,
            active: true,
        });
    }
    static getByAccountAndKeySync(db, acctId, key) {
        try {
            return db.accountMetadata.findOne({
                accountId: acctId,
                key,
            });
        }
        catch (e) {
            console.log('[WARN]: failed to get account metadata', e);
            return null;
        }
    }
    static upsert(db, dto) {
        const where = {
            accountId: dto.accountId,
            key: dto.key,
        };
        try {
            const duplicate = db.accountMetadata.findOne(where);
            if (duplicate) {
                db.accountMetadata.update(where, {
                    value: dto.value,
                    type: dto.type,
                });
            }
            else {
                db.accountMetadata.insert({
                    key: dto.key,
                    value: dto.value,
                    type: dto.type,
                    accountId: dto.accountId,
                });
            }
        }
        catch (e) {
            throw new Error(`failed to upsert account metadata`);
        }
    }
    static upsertMultiple(db, inputs) {
        for (const input of inputs) {
            Repo.upsert(db, input);
        }
    }
};
Repo = __decorate([
    DbErrorHandler()
], Repo);
class Service {
    static upsertMultiple(db, acct, metadata) {
        Repo.upsertMultiple(db, metadata.map((o) => ({ ...o, accountId: acct.id })));
    }
    static getAccountDid(db, acct) {
        return this.getKeyValueForAccountSync(db, acct, ACCOUNT_METADATA_KEY.ATPROTO_DID);
    }
    static upsert(db, acct, input) {
        return Repo.upsert(db, { ...input, accountId: acct.id });
    }
    static async getAtpSessionData(db, acct) {
        try {
            const accessJwt = Repo.getByAccountAndKeySync(db, acct.id, 'accessToken')?.value;
            const refreshJwt = Repo.getByAccountAndKeySync(db, acct.id, 'refreshToken')?.value;
            const did = Repo.getByAccountAndKeySync(db, acct.id, 'did')?.value;
            if (!accessJwt || !refreshJwt || !did) {
                console.log('[ERROR]: atproto session data unavailable in db');
                return null;
            }
            return {
                accessJwt,
                refreshJwt,
                handle: acct.username,
                did,
            };
        }
        catch (e) {
            console.log('[ERROR]: reconstructing cached atp data', e);
            return null;
        }
    }
    static getKeyValueForAccountSync(db, acct, key) {
        return Repo.getByAccountAndKeySync(db, acct.id, key)?.value;
    }
    static getAllKeysForAccount(db, acct) {
        return Repo.getAllKeysForAccount(db, acct.id);
    }
}
export { Repo as AccountMetadataRepo, Service as AccountMetadataService };
//# sourceMappingURL=account-metadata.js.map