import { DataSource } from '../dataSource.js';
import { Account, AccountCollection, AccountSavedPost } from '../_schema.js';
export declare enum ReservedCollection {
    DEFAULT = "__default__",
    LIKES = "__likes__",
    BOOKMARKS = "__bookmarks__"
}
export declare const reservedCollectionName: Record<ReservedCollection, string>;
declare class Repo {
}
declare class Service {
    static renameCollection(db: DataSource, id: number | string, name: string): void;
    static addCollection(db: DataSource, acct: Account, name: string): void;
    static describeCollection(db: DataSource, id: number | string, desc: string): void;
    static removeCollection(db: DataSource, id: number): AccountCollection | null;
    static listAll(db: DataSource): AccountCollection[];
    static listAllForAccount(db: DataSource, acct: Account): AccountCollection[];
    static toggleLink(db: DataSource, collection: AccountCollection, savedPost: AccountSavedPost): import("../_schema.js").CollectionSavedPost | null | undefined;
    static upsertReservedCollections(db: DataSource, acct: Account, identifier: ReservedCollection): void;
}
export { Repo as AccountCollectionRepo, Service as AccountCollectionService };
//# sourceMappingURL=account-collection.d.ts.map