import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
const searchTabs = [
    'explore',
    'top',
    'latest',
    'feeds',
    'posts',
    'users',
    'tags',
    'links',
    'news',
    'home',
];
const searchResultTypes = ['posts', 'users', 'links', 'tags', 'feeds'];
export const defaultAppSearchResults = {
    users: [],
    posts: [],
    tags: [],
    links: [],
};
var ACTION;
(function (ACTION) {
    ACTION[ACTION["SET_SEARCH"] = 0] = "SET_SEARCH";
    ACTION[ACTION["CLEAR_SEARCH"] = 1] = "CLEAR_SEARCH";
    ACTION[ACTION["APPLY_SEARCH"] = 2] = "APPLY_SEARCH";
    ACTION[ACTION["SET_CATEGORY"] = 3] = "SET_CATEGORY";
    ACTION[ACTION["SET_CATEGORY_POSTS"] = 4] = "SET_CATEGORY_POSTS";
    ACTION[ACTION["SET_CATEGORY_USERS"] = 5] = "SET_CATEGORY_USERS";
    ACTION[ACTION["SET_CATEGORY_TAGS"] = 6] = "SET_CATEGORY_TAGS";
    ACTION[ACTION["SET_CATEGORY_LINKS"] = 7] = "SET_CATEGORY_LINKS";
    ACTION[ACTION["SET_SEARCH_RESULTS"] = 8] = "SET_SEARCH_RESULTS";
    ACTION[ACTION["MARK_LOADING_DONE"] = 9] = "MARK_LOADING_DONE";
})(ACTION || (ACTION = {}));
const DEFAULT = {
    text: null,
    q: null,
    tab: 'home',
    category: null,
    results: defaultAppSearchResults,
    searchStatus: 'idle',
};
function convertTabToResultPageType(tab, q) {
    if (!q)
        return null;
    switch (tab) {
        case 'users':
            return 'users';
        case 'top':
        case 'latest':
        case 'posts':
            return 'posts';
        case 'tags':
            return 'tags';
        case 'feeds':
            return 'feeds';
        default:
            return null;
    }
}
function reducer(state, action) {
    switch (action.type) {
        case ACTION.SET_SEARCH: {
            return produce(state, (draft) => {
                draft.text = action.payload.q === '' ? null : action.payload.q;
            });
        }
        case ACTION.CLEAR_SEARCH: {
            return produce(state, (draft) => {
                draft.text = null;
                draft.q = null;
            });
        }
        case ACTION.APPLY_SEARCH: {
            return produce(state, (draft) => {
                draft.q = draft.text;
                draft.category = convertTabToResultPageType(draft.tab, draft.text);
                draft.searchStatus = 'loading';
            });
        }
        case ACTION.SET_CATEGORY: {
            return produce(state, (draft) => {
                draft.tab = action.payload.tab;
                draft.category = convertTabToResultPageType(action.payload.tab, state.q);
            });
        }
        case ACTION.SET_CATEGORY_USERS: {
            return produce(state, (draft) => {
                draft.category = 'users';
            });
        }
        case ACTION.SET_CATEGORY_POSTS: {
            return produce(state, (draft) => {
                draft.category = 'posts';
            });
        }
        case ACTION.SET_CATEGORY_TAGS: {
            return produce(state, (draft) => {
                draft.category = 'tags';
            });
        }
        case ACTION.SET_CATEGORY_LINKS: {
            return produce(state, (draft) => {
                draft.category = 'links';
            });
        }
        case ACTION.MARK_LOADING_DONE: {
            return produce(state, (draft) => {
                draft.searchStatus = 'idle';
            });
        }
        default:
            return state;
    }
}
const StateCtx = createContext(DEFAULT);
const DispatchCtx = createContext(null);
const useDiscoverState = () => useContext(StateCtx);
const useDiscoverDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as DiscoverCtx, useDiscoverState, useDiscoverDispatch, ACTION as DiscoverStateAction, };
//# sourceMappingURL=search-results.js.map