import type { DhaagaJsTimelineQueryOptions } from '@dhaaga/bridge';
import type { PostObjectType, ResultPage } from '@dhaaga/bridge';
import { DataSource } from '@dhaaga/db';
import { type Dispatch, type ReactNode } from 'react';
import { type TimelineReducerBaseState } from './_timeline.shared.js';
type AppTimelineQueryOptions = DhaagaJsTimelineQueryOptions;
type PageType = ResultPage<PostObjectType[]>;
declare enum TimelineFetchMode {
    IDLE = "Idle",
    HOME = "Home",
    LOCAL = "Local",
    FEDERATED = "Federated",
    SOCIAL = "Social",
    BUBBLE = "Bubble",
    HASHTAG = "Hashtag",
    USER = "User",
    LIST = "List",
    ANTENNA = "Antenna",
    REMOTE_TIMELINE = "Remote Timeline",
    ADD_NEW = "Add New",
    BOOKMARKS = "Bookmarks",
    LIKES = "Likes",
    FEED = "Feed",
    MY_POSTS = "MyPosts",
    TRENDING_POSTS = "TrendingPosts",
    TRENDING_USERS = "TrendingUsers",
    TRENDING_TAGS = "TrendingTags"
}
type State = TimelineReducerBaseState<PostObjectType> & {
    feedType: TimelineFetchMode;
    opts: AppTimelineQueryOptions;
    query: {
        id: string;
        label: string;
    } | null;
    isWidgetVisible: boolean;
};
declare enum ACTION {
    INIT = 0,
    RESET_USING_QUERY = 1,
    RESET_USING_PIN_ID = 2,
    APPEND_RESULTS = 3,
    SET_QUERY_PARAMS = 4,
    SET_QUERY_OPTS = 5,
    REQUEST_LOAD_MORE = 6,
    RESET = 7,
    SHOW_WIDGET = 8,
    HIDE_WIDGET = 9,
    UPDATE_BOOKMARK_STATUS = 10,
    UPDATE_BOOST_STATUS = 11,
    UPDATE_TRANSLATION_OUTPUT = 12,
    UPDATE_LIKE_STATUS = 13,
    UPDATE_REACTION_STATE = 14,
    POST_OBJECT_CHANGED = 15,
    SETUP_USER_POST_TIMELINE = 16,
    SETUP_CUSTOM_FEED_TIMELINE = 17
}
type Actions = {
    type: ACTION.INIT;
    payload: {
        db: DataSource;
    };
} | {
    type: ACTION.RESET_USING_QUERY;
    payload: {
        type: TimelineFetchMode;
    };
} | {
    type: ACTION.RESET_USING_PIN_ID;
    payload: {
        id: number;
        type: 'feed' | 'user' | 'tag';
    };
} | {
    type: ACTION.APPEND_RESULTS;
    payload: PageType;
} | {
    type: ACTION.SET_QUERY_PARAMS;
    payload: AppTimelineQueryOptions;
} | {
    type: ACTION.REQUEST_LOAD_MORE;
} | {
    type: ACTION.RESET;
} | {
    type: ACTION.SHOW_WIDGET;
} | {
    type: ACTION.HIDE_WIDGET;
} | {
    type: ACTION.SET_QUERY_OPTS;
    payload: AppTimelineQueryOptions;
} | {
    type: ACTION.UPDATE_BOOKMARK_STATUS;
    payload: {
        id: string;
        value: boolean;
    };
} | {
    type: ACTION.UPDATE_BOOST_STATUS;
    payload: {
        id: string;
        delta: number;
    };
} | {
    type: ACTION.UPDATE_TRANSLATION_OUTPUT;
    payload: {
        id: string;
        outputText: string;
        outputType: string;
    };
} | {
    type: ACTION.UPDATE_LIKE_STATUS;
    payload: {
        id: string;
        delta: number;
    };
} | {
    type: ACTION.UPDATE_REACTION_STATE;
    payload: {
        id: string;
        state: any;
    };
} | {
    type: ACTION.POST_OBJECT_CHANGED;
    payload: {
        item: PostObjectType;
    };
} | {
    type: ACTION.SETUP_USER_POST_TIMELINE;
    payload: {
        id: string;
        label: string;
    };
} | {
    type: ACTION.SETUP_CUSTOM_FEED_TIMELINE;
    payload: {
        uri: string;
        label: string;
    };
};
type DispatchType = Dispatch<Actions>;
declare const usePostTimelineState: () => State;
declare const usePostTimelineDispatch: () => DispatchType;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { TimelineFetchMode, Ctx as PostTimelineCtx, usePostTimelineState, usePostTimelineDispatch, ACTION as PostTimelineStateAction, };
export type { State as PostTimelineStateType, DispatchType as PostTimelineDispatchType, };
//# sourceMappingURL=post-timeline.d.ts.map