import { jsx as _jsx } from "react/jsx-runtime";
import { produce } from 'immer';
import { createContext, useContext, useReducer, } from 'react';
const DEFAULT = {
    seen: new Set(),
    items: [],
    listEmpty: false,
    maxId: null,
    appliedMaxId: null,
    endOfList: false,
};
var ACTION;
(function (ACTION) {
    ACTION[ACTION["APPEND"] = 0] = "APPEND";
    ACTION[ACTION["RESET"] = 1] = "RESET";
    ACTION[ACTION["LOAD_NEXT_PAGE"] = 2] = "LOAD_NEXT_PAGE";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.RESET: {
            return DEFAULT;
        }
        case ACTION.APPEND: {
            return produce(state, (draft) => {
                if (action.payload.page.data.length === 0 && state.items.length === 0)
                    draft.listEmpty = true;
                for (const item of action.payload.page.data) {
                    if (draft.seen.has(item.id))
                        continue;
                    draft.seen.add(item.id);
                    draft.items.push(item);
                }
                draft.maxId =
                    action.payload.page.maxId ??
                        (action.payload.page.data.length > 0
                            ? action.payload.page.data[action.payload.page.data.length - 1].id
                            : null);
                draft.endOfList = !draft.maxId;
            });
        }
        case ACTION.LOAD_NEXT_PAGE: {
            return produce(state, (draft) => {
                draft.appliedMaxId = state.maxId;
            });
        }
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useInboxState = () => useContext(StateCtx);
const useInboxDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as InboxCtx, useInboxState, useInboxDispatch, ACTION as InboxStateAction, };
//# sourceMappingURL=inbox.js.map