import { type Dispatch, type ReactNode } from 'react';
import type { NotificationObjectType, ResultPage } from '@dhaaga/bridge';
type State = {
    seen: Set<string>;
    items: NotificationObjectType[];
    listEmpty: boolean;
    maxId: string | null;
    appliedMaxId: string | null;
    endOfList: boolean;
};
declare enum ACTION {
    APPEND = 0,
    RESET = 1,
    LOAD_NEXT_PAGE = 2
}
type Actions = {
    type: ACTION.APPEND;
    payload: {
        page: ResultPage<NotificationObjectType[]>;
    };
} | {
    type: ACTION.RESET;
} | {
    type: ACTION.LOAD_NEXT_PAGE;
};
type DispatchType = Dispatch<Actions>;
declare const useInboxState: () => State | null;
declare const useInboxDispatch: () => DispatchType | null;
declare function Ctx({ children }: {
    children: ReactNode;
}): import("react/jsx-runtime").JSX.Element;
export { Ctx as InboxCtx, useInboxState, useInboxDispatch, ACTION as InboxStateAction, };
export type { State as InboxStateType, DispatchType as InboxDispatchType };
//# sourceMappingURL=inbox.d.ts.map