import { jsx as _jsx } from "react/jsx-runtime";
import { DataSource } from '@dhaaga/db';
import { timelineReducerBaseDefaults, } from './_timeline.shared.js';
import { produce } from 'immer';
import { RandomUtil } from '@dhaaga/bridge';
import { createContext, useContext, useReducer, } from 'react';
export const DEFAULT = {
    ...timelineReducerBaseDefaults,
    items: [],
};
export { ACTION };
var ACTION;
(function (ACTION) {
    ACTION[ACTION["INIT"] = 0] = "INIT";
    ACTION[ACTION["RESET"] = 1] = "RESET";
    ACTION[ACTION["APPEND_RESULTS"] = 2] = "APPEND_RESULTS";
    ACTION[ACTION["REQUEST_LOAD_MORE"] = 3] = "REQUEST_LOAD_MORE";
    ACTION[ACTION["SET_QUERY_OPTS"] = 4] = "SET_QUERY_OPTS";
})(ACTION || (ACTION = {}));
function reducer(state, action) {
    switch (action.type) {
        case ACTION.INIT: {
            return produce(state, (draft) => {
                draft.db = action.payload.db;
                draft.seen = new Set();
                draft.sessionId = RandomUtil.nanoId();
            });
        }
        case ACTION.RESET: {
            return produce(state, (draft) => {
                draft.items = [];
                draft.maxId = null;
                draft.minId = null;
                draft.isEol = false;
                draft.isFirstLoad = false;
                draft.seen = new Set();
            });
        }
        case ACTION.REQUEST_LOAD_MORE: {
            return produce(state, (draft) => {
                draft.appliedMaxId = state.maxId;
            });
        }
        case ACTION.APPEND_RESULTS: {
            const copy = Array.from(state.items);
            for (const item of action.payload.data) {
                if (state.seen.has(item.uri))
                    continue;
                copy.push(item);
            }
            return produce(state, (draft) => {
                draft.items = copy;
                draft.maxId = action.payload.maxId;
            });
        }
        case ACTION.SET_QUERY_OPTS: {
            return produce(state, (draft) => {
                draft.opts = action.payload;
            });
        }
        default:
            return state;
    }
}
const StateCtx = createContext(null);
const DispatchCtx = createContext(null);
const useFeedTimelineState = () => useContext(StateCtx);
const useFeedTimelineDispatch = () => useContext(DispatchCtx);
function Ctx({ children }) {
    const [state, dispatch] = useReducer(reducer, DEFAULT);
    return (_jsx(StateCtx.Provider, { value: state, children: _jsx(DispatchCtx.Provider, { value: dispatch, children: children }) }));
}
export { Ctx as FeedTimelineCtx, useFeedTimelineState, useFeedTimelineDispatch, ACTION as FeedTimelineStateAction, };
//# sourceMappingURL=feed-timeline.js.map