export class BaseUrlNormalizationService {
    static appendHttps(input) {
        try {
            const hasProtocol = /^https?:\/\//i.test(input);
            const url = new URL(hasProtocol ? input : `https://${input}`);
            url.protocol = 'https:';
            url.pathname = '';
            url.search = '';
            url.hash = '';
            return url.toString().replace(/\/$/, '');
        }
        catch (e) {
            throw new Error(`Invalid URL: ${input}`);
        }
    }
    static stripHttps(input) {
        try {
            const hasProtocol = /^https?:\/\//i.test(input);
            const url = new URL(hasProtocol ? input : `https://${input}`);
            let host = url.host;
            host = host.replace(/^www\./i, '');
            return host;
        }
        catch (e) {
            throw new Error(`Invalid URL: ${input}`);
        }
    }
}
//# sourceMappingURL=urls.js.map