import '#/index.js';
import { PostParser } from '#/index.js';
export function postThreadInterfaceToObjectChain(data, client, anchor) {
    let parents = [];
    let currentHead = data.ancestors.find((o) => !o.post.isReply());
    while (currentHead && currentHead.id !== anchor.id) {
        const parsedParent = PostParser.interfaceToJson(currentHead.post, {
            driver: client.driver,
            server: client.server,
        });
        parents.push(parsedParent);
        currentHead = data.ancestors.find((o) => o.post.getParentStatusId() === currentHead.post.getId());
    }
    let lookup = new Map();
    let childrenMapper = new Map();
    data.descendants.forEach((o) => {
        console.log(o.post.getId(), o.post.getParentStatusId(), anchor.id);
    });
    function findChildren(post) {
        lookup.set(post.id, post);
        const children = data.descendants.filter((o) => o.post.getParentStatusId() === post.id);
        let validChildren = [];
        children.forEach((o) => {
            const parsed = PostParser.interfaceToJson(o.post, {
                driver: client.driver,
                server: client.server,
            });
            if (!parsed) {
                console.log('[WARN]: failed to parse post');
            }
            else {
                findChildren(parsed);
                validChildren.push(parsed.id);
            }
        });
        childrenMapper.set(post.id, validChildren);
    }
    findChildren(anchor);
    return {
        history: parents.filter((o) => !!o),
        anchor,
        itemLookup: lookup,
        childrenLookup: childrenMapper,
    };
}
//# sourceMappingURL=solve-post-thread.js.map