class Util {
    static toSnakeCase = (str) => str.replace(/[A-Z]/g, (letter) => `_${letter.toLowerCase()}`);
    static toCamelCase = (str) => str.replace(/_([a-z])/g, (match, letter) => letter.toUpperCase());
    static snakeCaseKeys(obj) {
        if (!obj || typeof obj !== 'object')
            return obj;
        if (Array.isArray(obj))
            return obj.map((item) => Util.snakeCaseKeys(item));
        return Object.entries(obj)
            .filter(([k, v]) => v !== undefined)
            .reduce((acc, [key, value]) => {
            const newKey = Util.toSnakeCase(key);
            acc[newKey] =
                value && typeof value === 'object'
                    ? Util.snakeCaseKeys(value)
                    : value;
            return acc;
        }, {});
    }
    static camelCaseKeys(obj) {
        if (!obj || typeof obj !== 'object')
            return obj;
        if (Array.isArray(obj))
            return obj.map((item) => Util.camelCaseKeys(item));
        return Object.entries(obj)
            .filter(([k, v]) => v !== undefined)
            .reduce((acc, [key, value]) => {
            const newKey = Util.toCamelCase(key);
            acc[newKey] =
                value && typeof value === 'object'
                    ? Util.camelCaseKeys(value)
                    : value;
            return acc;
        }, {});
    }
}
export { Util as CasingUtil };
//# sourceMappingURL=casing.js.map