import { AtpAgent } from '@atproto/api';
class Util {
    static async generateFeedUrl(client, uri) {
        const feed = await client.timelines.getFeedGenerator(uri);
        if (!feed.data.isValid)
            throw new Error('E_Feed_Invalid');
        if (!feed.data.isOnline)
            throw new Error('E_Feed_Offline');
        const regex = /([^/]+)$/;
        if (regex.test(feed.data.view.uri)) {
            const feedUrl = feed.data.view.uri.match(regex)[1];
            const handle = feed.data.view.creator.handle;
            return `https://bsky.app/profile/${handle}/feed/${feedUrl}`;
        }
        throw new Error('E_Feed_Has_Invalid_Regex');
    }
}
function getBskyAgent(dto) {
    const agent = new AtpAgent({
        service: 'https://bsky.social',
    });
    agent.sessionManager.session = dto;
    return agent;
}
function getXrpcAgent(dto) {
    const agent = new AtpAgent({
        service: `${dto.pdsUrl}/xrpc`,
    });
    agent.sessionManager.session = dto;
    return agent;
}
function getChatAgent(dto) {
    const agent = new AtpAgent({
        service: dto.pdsUrl,
    });
    agent.sessionManager.session = dto;
    return agent;
}
export { Util as AtprotoUtils, getBskyAgent, getXrpcAgent, getChatAgent };
//# sourceMappingURL=atproto.js.map